/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metrics;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.util.ModelMetrics;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metrics.MetricObject;
import edu.stanford.smi.protegex.owl.ui.metrics.MetricRenderer;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class MetricsPanel
extends JPanel {
    private JTree tree;
    public static final Icon headerIcon = OWLIcons.getImageIcon("metricsheadericon.png");
    public static final Icon dataIcon = OWLIcons.getImageIcon("metricsdataicon.png");

    public MetricsPanel(OWLModel oWLModel) {
        ModelMetrics modelMetrics = new ModelMetrics(oWLModel);
        modelMetrics.calculateMetrics();
        this.tree = new JTree(this.createRootNode(modelMetrics));
        this.tree.setCellRenderer(new MetricRenderer());
        this.setLayout(new BorderLayout(7, 7));
        this.add(new JScrollPane(this.tree));
        this.expandTree();
    }

    public void expandTree() {
        this.tree.setSelectionRow(0);
        ComponentUtilities.fullSelectionExpand((JTree)this.tree, (int)100);
    }

    private TreeNode createRootNode(ModelMetrics modelMetrics) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Metrics");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Classes");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Named classes");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3.add(this.createMetricNode("Total", modelMetrics.getNamedClassCount()));
        defaultMutableTreeNode3.add(this.createMetricNode("Primitive", modelMetrics.getPrimitiveClassCount()));
        defaultMutableTreeNode3.add(this.createMetricNode("Defined", modelMetrics.getDefinedClassCount()));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Parents");
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode4.add(this.createMetricNode("Mean (named)", modelMetrics.getMeanParents()));
        defaultMutableTreeNode4.add(this.createMetricNode("Mode (named)", modelMetrics.getModeParents()));
        defaultMutableTreeNode4.add(this.createMetricNode("Max (named)", modelMetrics.getMaxParents()));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Inferred parents");
        defaultMutableTreeNode3.add(defaultMutableTreeNode5);
        defaultMutableTreeNode5.add(this.createMetricNode("Mean (named)", modelMetrics.getMeanInferredParents()));
        defaultMutableTreeNode5.add(this.createMetricNode("Mode (named)", modelMetrics.getModeInferredParents()));
        defaultMutableTreeNode5.add(this.createMetricNode("Max (named)", modelMetrics.getMaxInferredParents()));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Siblings");
        defaultMutableTreeNode3.add(defaultMutableTreeNode6);
        defaultMutableTreeNode6.add(this.createMetricNode("Mean", modelMetrics.getMeanSiblings()));
        defaultMutableTreeNode6.add(this.createMetricNode("Mode", modelMetrics.getModeSiblings()));
        defaultMutableTreeNode6.add(this.createMetricNode("Max", modelMetrics.getMaxSiblings()));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("Anonymous Classes");
        defaultMutableTreeNode2.add(defaultMutableTreeNode7);
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("Restrictions");
        defaultMutableTreeNode7.add(defaultMutableTreeNode8);
        defaultMutableTreeNode8.add(this.createMetricNode("Total", modelMetrics.getRestrictionCount()));
        defaultMutableTreeNode8.add(this.createMetricNode("Existential", modelMetrics.getSomeValuesFromCount()));
        defaultMutableTreeNode8.add(this.createMetricNode("Universal", modelMetrics.getAllValuesFromCount()));
        defaultMutableTreeNode8.add(this.createMetricNode("Cardinality", modelMetrics.getCardinalityCount()));
        defaultMutableTreeNode8.add(this.createMetricNode("MinCardinality", modelMetrics.getMinCardinalityCount()));
        defaultMutableTreeNode8.add(this.createMetricNode("MaxCardinality", modelMetrics.getMaxCardinalityCount()));
        defaultMutableTreeNode8.add(this.createMetricNode("HasValue", modelMetrics.getHasValueCount()));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode("Properties");
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode9.add(this.createMetricNode("Total", modelMetrics.getObjectPropertyCount()));
        defaultMutableTreeNode9.add(this.createMetricNode("Object", modelMetrics.getObjectPropertyCount()));
        defaultMutableTreeNode9.add(this.createMetricNode("Datatype", modelMetrics.getDatatypePropertyCount()));
        defaultMutableTreeNode9.add(this.createMetricNode("Annotation", modelMetrics.getAnnotationPropertyCount()));
        defaultMutableTreeNode9.add(this.createMetricNode("Properties with a domain specified", modelMetrics.getPropertDomainCount()));
        defaultMutableTreeNode9.add(this.createMetricNode("Properties with a range specified", modelMetrics.getPropertyRangeCount()));
        defaultMutableTreeNode9.add(this.createMetricNode("Properties with an inverse specified", modelMetrics.getInversePropertyCount()));
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createMetricNode(String string, Object object) {
        return new DefaultMutableTreeNode(new MetricObject(string, object));
    }

    private DefaultMutableTreeNode createMetricNode(String string, int n) {
        return this.createMetricNode(string, new Integer(n));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(400, dimension.height / 2);
    }
}

