/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.prefixes;

import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerAdapter;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.AbstractNamespaceManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PrefixesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4288139995372553605L;
    private OWLOntology ontology;
    public static final int COL_PREFIX = 0;
    public static final int COL_NAMESPACE = 1;
    public static final int COL_COUNT = 2;
    private List<String> prefixes = new ArrayList<String>();

    public PrefixesTableModel(OWLOntology oWLOntology) {
        this.ontology = oWLOntology;
        this.fill();
        this.getNamespaceManager().addNamespaceManagerListener(new NamespaceManagerAdapter(){

            public void namespaceChanged(String string, String string2, String string3) {
                PrefixesTableModel.this.fill();
                PrefixesTableModel.this.fireTableDataChanged();
            }
        });
    }

    private void fill() {
        this.prefixes = new ArrayList<String>(this.getNamespaceManager().getPrefixes());
        Collections.sort(this.prefixes);
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Prefix";
        }
        if (n == 1) {
            return "Namespace";
        }
        return null;
    }

    public String getNamespace(int n) {
        String string = this.getPrefix(n);
        return this.getNamespaceManager().getNamespaceForPrefix(string);
    }

    NamespaceManager getNamespaceManager() {
        return this.ontology.getOWLModel().getNamespaceManager();
    }

    public String getPrefix(int n) {
        return this.prefixes.get(n);
    }

    int getPrefixRow(String string) {
        return this.prefixes.indexOf(string);
    }

    public int getRowCount() {
        return this.prefixes.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.getPrefix(n);
        }
        if (n2 == 1) {
            return this.getNamespace(n);
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        String string = this.getPrefix(n);
        return this.isPrefixEditable(string);
    }

    public boolean isNamespaceEditable(String string) {
        String string2 = this.getNamespaceManager().getPrefix(string);
        return this.isPrefixEditable(string2);
    }

    boolean isPrefixEditable(String string) {
        return this.getNamespaceManager().isModifiable(string);
    }

    public void setValueAt(Object object, int n, int n2) {
        NamespaceManager namespaceManager = this.getNamespaceManager();
        if (n2 == 0) {
            String string = (String)object;
            if (namespaceManager.getNamespaceForPrefix(string) == null && (string.equals("") || AbstractNamespaceManager.isValidPrefix(string))) {
                String string2 = this.getNamespace(n);
                this.setPrefixOfNamespace(string2, string);
            }
        } else if (n2 == 1) {
            String string = (String)object;
            String string3 = namespaceManager.getDefaultNamespace();
            if (namespaceManager.getPrefix(string) == null && (string3 == null || !string3.equals(string)) && Jena.isNamespaceWithSeparator(string)) {
                String string4 = this.getPrefix(n);
                this.setNamespaceOfPrefix(string4, string);
            }
        }
        this.fill();
        this.fireTableDataChanged();
    }

    private void setNamespaceOfPrefix(String string, String string2) {
        OWLModel oWLModel = this.ontology.getOWLModel();
        try {
            oWLModel.beginTransaction("Change namespace of " + string + " to " + string2, this.ontology.getName());
            oWLModel.getNamespaceManager().setPrefix(string2, string);
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
    }

    private void setPrefixOfNamespace(String string, String string2) {
        OWLModel oWLModel = this.ontology.getOWLModel();
        try {
            oWLModel.beginTransaction("Change prefix of " + string + " to " + string2, this.ontology.getName());
            oWLModel.getNamespaceManager().setPrefix(string, string2);
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
    }

    public int getRowOfPrefix(String string) {
        return this.prefixes.indexOf(string);
    }
}

