/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.prefixes;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.widget.PropertiesTableModel;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerAdapter;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metadatatab.prefixes.PrefixesTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PrefixesPanel
extends JPanel
implements Disposable {
    private Action addAction = new AbstractAction("Add new prefix", OWLIcons.getAddIcon("Prefix")){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLModel oWLModel = PrefixesPanel.this.ontology.getOWLModel();
            try {
                oWLModel.beginTransaction("Add new namespace prefix", PrefixesPanel.this.ontology.getName());
                PrefixesPanel.this.addPrefix();
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
        }
    };
    private TableCellRenderer namespaceCellRenderer = new DefaultTableCellRenderer(){

        protected void setValue(Object object) {
            super.setValue(object);
            if (object instanceof String && !PrefixesPanel.this.tableModel.isNamespaceEditable((String)object)) {
                this.setForeground(UNEDITABLE_COLOR);
            } else {
                this.setForeground(Color.black);
            }
        }
    };
    private TableCellRenderer prefixCellRenderer = new DefaultTableCellRenderer(){

        protected void setValue(Object object) {
            super.setValue(object);
            if (object instanceof String && !PrefixesPanel.this.tableModel.isPrefixEditable((String)object)) {
                this.setForeground(UNEDITABLE_COLOR);
            } else {
                this.setForeground(Color.black);
            }
        }
    };
    private JTextField defaultNamespaceField;
    private NamespaceManagerAdapter namespaceManagerListener = new NamespaceManagerAdapter(){

        public void defaultNamespaceChanged(String string, String string2) {
            PrefixesPanel.this.defaultNamespaceField.setText(string2);
        }
    };
    private OWLOntology ontology;
    private Action removeAction = new AbstractAction("Remove selected prefix", OWLIcons.getRemoveIcon("Prefix")){

        public void actionPerformed(ActionEvent actionEvent) {
            PrefixesPanel.this.removePrefix();
        }
    };
    private SelectableTable table;
    private PrefixesTableModel tableModel;
    private static final Color UNEDITABLE_COLOR = Color.darkGray;

    public PrefixesPanel(OWLOntology oWLOntology) {
        this.ontology = oWLOntology;
        this.table = new SelectableTable(){
            private static final long serialVersionUID = 6379511196511156925L;

            public void editingStopped(ChangeEvent changeEvent) {
                int n;
                int n2 = this.getEditingColumn();
                String string = (String)this.getCellEditor().getCellEditorValue();
                super.editingStopped(changeEvent);
                if (n2 == 0 && (n = ((PrefixesTableModel)this.getModel()).getRowOfPrefix(string)) >= 0) {
                    ComponentUtilities.scrollToVisible((JTable)PrefixesPanel.this.table, (int)n, (int)0);
                    PrefixesPanel.this.table.setRowSelectionInterval(n, n);
                    PrefixesPanel.this.table.editCellAt(n, PropertiesTableModel.getValueColumnIndex());
                    PrefixesPanel.this.table.requestFocus();
                }
            }
        };
        this.tableModel = new PrefixesTableModel(oWLOntology);
        this.table.setModel((TableModel)this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(80);
        tableColumn.setMaxWidth(80);
        tableColumn.setCellRenderer(this.prefixCellRenderer);
        tableColumn2.setPreferredWidth(200);
        tableColumn2.setCellRenderer(this.namespaceCellRenderer);
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Namespace Prefixes", jScrollPane);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        this.removeAction.setEnabled(false);
        oWLLabeledComponent.addHeaderButton(this.addAction);
        oWLLabeledComponent.addHeaderButton(this.removeAction);
        this.createDefaultNamespacePanel();
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PrefixesPanel.this.enableActions();
            }
        });
        this.tableModel.getNamespaceManager().addNamespaceManagerListener(this.namespaceManagerListener);
    }

    private String addPrefix() {
        NamespaceManager namespaceManager = this.tableModel.getNamespaceManager();
        String string = PrefixesPanel.addPrefix(namespaceManager);
        int n = this.tableModel.getPrefixRow(string);
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
        this.table.requestFocus();
        this.table.editCellAt(n, 0);
        return string;
    }

    public static String addPrefix(NamespaceManager namespaceManager) {
        int n = 1;
        String string = null;
        while (namespaceManager.getNamespaceForPrefix(string = "p" + n++) != null) {
        }
        String string2 = null;
        while (namespaceManager.getPrefix(string2 = "http://www.domain" + n++ + ".com#") != null) {
        }
        namespaceManager.setPrefix(string2, string);
        return string;
    }

    private void createDefaultNamespacePanel() {
        NamespaceManager namespaceManager = this.tableModel.getNamespaceManager();
        String string = namespaceManager.getDefaultNamespace();
        this.defaultNamespaceField = new JTextField(string);
        this.defaultNamespaceField.setEditable(false);
        this.defaultNamespaceField.setMinimumSize(new Dimension(this.defaultNamespaceField.getPreferredSize().width, 30));
    }

    public void dispose() {
    }

    private void enableActions() {
        this.removeAction.setEnabled(this.enableRemove());
    }

    private boolean enableRemove() {
        int n = this.table.getSelectedRow();
        if (n < 0 || !this.isEnabled()) {
            return false;
        }
        if (!this.tableModel.getNamespaceManager().isModifiable(this.tableModel.getPrefix(n))) {
            return false;
        }
        TripleStore tripleStore = this.ontology.getOWLModel().getTripleStoreModel().getTopTripleStore();
        NamespaceManager namespaceManager = tripleStore.getNamespaceManager();
        Object object = this.table.getValueAt(n, 0);
        return object != null && object instanceof String && namespaceManager.getNamespaceForPrefix((String)object) != null;
    }

    public Component getDefaultNamespaceField() {
        return this.defaultNamespaceField;
    }

    public String getSelectedNamespace() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 1) {
            return this.tableModel.getNamespace(nArray[0]);
        }
        return null;
    }

    private void makeDefault() {
        OWLModel oWLModel = this.ontology.getOWLModel();
        try {
            int n = this.table.getSelectedRow();
            String string = this.tableModel.getPrefix(n);
            NamespaceManager namespaceManager = this.tableModel.getNamespaceManager();
            String string2 = namespaceManager.getNamespaceForPrefix(string);
            try {
                oWLModel.beginTransaction("Make " + string2 + " the default namespace", this.ontology.getName());
                namespaceManager.setDefaultNamespace(string2);
                namespaceManager.removePrefix(string);
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
        }
        catch (Exception exception) {
            OWLUI.handleError(oWLModel, exception);
        }
    }

    private void removePrefix() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().cancelCellEditing();
        }
        int n = this.table.getSelectedRow();
        String string = this.tableModel.getPrefix(n);
        OWLModel oWLModel = this.ontology.getOWLModel();
        if (oWLModel.getRDFResource(string + ":") instanceof OWLOntology) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "The prefix \"" + string + "\" is used by an owl:Ontology element\n" + "of an imported ontology.  Please remove the corresponding\n" + "import first, and then remove the prefix.");
        } else {
            NamespaceManager namespaceManager = this.tableModel.getNamespaceManager();
            try {
                oWLModel.beginTransaction("Remove namespace prefix " + string, this.ontology.getName());
                namespaceManager.removePrefix(string);
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
        }
    }

    public void setSelectedURI(String string) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            String string2 = this.tableModel.getNamespace(i);
            if (!string2.startsWith(string)) continue;
            this.table.getSelectionModel().setSelectionInterval(i, i);
            return;
        }
        this.table.getSelectionModel().clearSelection();
    }

    public void setEnabled(boolean bl) {
        this.addAction.setEnabled(bl);
        this.removeAction.setEnabled(bl);
        this.table.setEnabled(bl);
        super.setEnabled(bl);
    }
}

