/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AbstractImportWizardPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportEntry;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ImportVerificationPage
extends AbstractImportWizardPage {
    private Thread checkerThread;
    private Collection errors;

    public ImportVerificationPage(ImportWizard importWizard) {
        super("Import verification page", importWizard);
        this.setPageComplete(false);
    }

    public void pageSelected() {
        this.setPageComplete(false);
        this.getContentComponent().removeAll();
        this.showProgressPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                ImportVerificationPage.this.errors = new ArrayList();
                Iterator iterator = ImportVerificationPage.this.getImportWizard().getImportData().getImportEntries().iterator();
                while (iterator.hasNext() && ImportVerificationPage.this.checkerThread != null) {
                    ImportEntry importEntry = (ImportEntry)iterator.next();
                    if (importEntry.isPossibleToImport()) continue;
                    ImportVerificationPage.this.errors.addAll(importEntry.getErrors());
                }
                if (ImportVerificationPage.this.checkerThread != null && Thread.currentThread().equals(ImportVerificationPage.this.checkerThread)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (ImportVerificationPage.this.errors.size() == 0) {
                                ImportVerificationPage.this.refill();
                            } else {
                                ImportVerificationPage.this.showErrorPanel();
                            }
                        }
                    });
                }
            }
        };
        this.checkerThread = new Thread(runnable);
        this.checkerThread.start();
    }

    public void prevPressed() {
        this.checkerThread = null;
        this.setPageComplete(false);
    }

    public void onCancel() {
        this.checkerThread = null;
    }

    private void showProgressPanel() {
        this.getContentComponent().removeAll();
        this.getContentComponent().add((Component)new ProgressPanel(), "North");
        this.validate();
    }

    private void showErrorPanel() {
        this.getContentComponent().removeAll();
        this.getContentComponent().add((Component)new ErrorPanel(), "North");
        this.validate();
    }

    private void refill() {
        this.setPageComplete(true);
        this.getContentComponent().removeAll();
        this.getContentComponent().add((Component)new ResultsPanel(), "North");
        this.validate();
    }

    private class ResultsPanel
    extends JPanel {
        public ResultsPanel() {
            Box box = new Box(1);
            for (ImportEntry importEntry : ImportVerificationPage.this.getImportWizard().getImportData().getImportEntries()) {
                URI uRI = importEntry.getOntologyURI();
                box.add(new JLabel(uRI.toString()));
                String string = "<html><body><font size=\"-2\" color=\"rgb(100, 100, 100)\">Imported from " + importEntry.getRepository().getOntologyLocationDescription(uRI) + "</font></body></html>";
                JLabel jLabel = new JLabel(string);
                jLabel.setBorder(BorderFactory.createEmptyBorder(5, 30, 5, 0));
                box.add(jLabel);
            }
            box.setBorder(BorderFactory.createEmptyBorder(5, 20, 20, 20));
            this.setLayout(new BorderLayout(7, 7));
            this.add((Component)new JScrollPane(box), "Center");
            this.add((Component)new JLabel("Press the finish button to import the following ontologies:"), "North");
        }
    }

    private class ErrorPanel
    extends JPanel {
        public ErrorPanel() {
            this.setLayout(new BorderLayout());
            String string = "<html><body>" + ImportVerificationPage.this.errors.toArray()[0].toString() + "<br><br>" + "Please press the Back button to specify another ontology.</body></html>";
            this.add(new JLabel(string, UIManager.getDefaults().getIcon("OptionPane.errorIcon"), 2));
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        }
    }

    private class ProgressPanel
    extends JPanel {
        private JLabel messageLabel;

        public ProgressPanel() {
            this.setLayout(new BorderLayout(7, 7));
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.messageLabel = new JLabel("Checking imports...");
            this.add((Component)this.messageLabel, "North");
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setIndeterminate(true);
            this.add((Component)jProgressBar, "South");
        }

        public void setMessage(String string) {
            this.messageLabel.setText(string);
        }
    }
}

