/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepository;
import edu.stanford.smi.protegex.owl.repository.util.FileInputSource;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AbstractImportEntry;
import java.io.File;

public class FileImportEntry
extends AbstractImportEntry {
    private File file;

    public FileImportEntry(File file) {
        this.file = file;
    }

    public boolean isPossibleToImport() {
        try {
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(new FileInputSource(this.file));
            if (!ontologyNameExtractor.isPossiblyValidOntology()) {
                throw new IllegalArgumentException("The document pointed to by " + this.file + " does not " + "appear to contain a valid RDF/XML representation of an ontology.");
            }
            this.setOntologyURI(ontologyNameExtractor.getOntologyName());
            this.setRepository(new LocalFileRepository(this.file));
            return true;
        }
        catch (Exception exception) {
            this.addError(exception);
            this.setOntologyURI(null);
            this.setRepository(null);
            return false;
        }
    }

    public Repository getRepositoryToAdd() {
        return this.getRepository();
    }
}

