/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepository;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport.EmptyImportExplanationPage;
import edu.stanford.smi.protegex.owl.ui.wizard.OWLWizard;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.JComponent;

public class EmptyImportWizard
extends OWLWizard {
    private URI ontologyURI;
    private File localFile;
    private OWLModel owlModel;

    public EmptyImportWizard(JComponent jComponent, OWLModel oWLModel) {
        super(jComponent, "Empty Import");
        this.owlModel = oWLModel;
        this.addPage(new EmptyImportExplanationPage(this, oWLModel));
    }

    protected void onFinish() {
        super.onFinish();
        try {
            if (this.localFile != null && this.ontologyURI != null) {
                JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModel();
                jenaOWLModel.getNamespaceManager().setDefaultNamespace(this.ontologyURI + "#");
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(this.localFile));
                OWLModelWriter oWLModelWriter = new OWLModelWriter((OWLModel)jenaOWLModel, jenaOWLModel.getTripleStoreModel().getActiveTripleStore(), outputStreamWriter);
                oWLModelWriter.write();
                outputStreamWriter.flush();
                outputStreamWriter.close();
                RepositoryManager repositoryManager = this.owlModel.getRepositoryManager();
                repositoryManager.addProjectRepository(new LocalFileRepository(this.localFile));
                ImportHelper importHelper = new ImportHelper((JenaOWLModel)this.owlModel);
                importHelper.addImport(this.ontologyURI);
                importHelper.importOntologies();
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }

    public URI getOntologyURI() {
        return this.ontologyURI;
    }

    public void setOntologyURI(URI uRI) {
        this.ontologyURI = uRI;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File file) {
        this.localFile = file;
    }
}

