/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ImportsTableModel
extends AbstractTableModel
implements Disposable {
    public static final int COL_URI = 0;
    public static final int COL_COUNT = 1;
    private PropertyValueListener listener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            if (OWLNames.Slot.IMPORTS.equals(rDFProperty.getName())) {
                ImportsTableModel.this.refill();
            }
        }
    };
    private OWLOntology ontology;
    private List uris = new ArrayList();

    public ImportsTableModel(OWLOntology oWLOntology) {
        this.ontology = oWLOntology;
        oWLOntology.addPropertyValueListener(this.listener);
        this.uris = new ArrayList<String>(oWLOntology.getImports());
    }

    public void addImport(String string) {
        this.ontology.addImports(string);
    }

    public void deleteRow(int n) {
        String string = this.getURI(n);
        this.ontology.removeImports(string);
    }

    public void dispose() {
        this.ontology.removePropertyValueListener(this.listener);
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Imported URI";
        }
        return null;
    }

    public NamespaceManager getNamespaceManager() {
        return this.ontology.getOWLModel().getNamespaceManager();
    }

    OWLModel getOWLModel() {
        return this.ontology.getOWLModel();
    }

    public int getRowCount() {
        return this.uris.size();
    }

    public String getURI(int n) {
        return (String)this.uris.get(n);
    }

    public int getURIRow(String string) {
        return this.uris.indexOf(string);
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.getURI(n);
        }
        return null;
    }

    private void refill() {
        this.uris = new ArrayList<String>(this.ontology.getImports());
        this.fireTableDataChanged();
    }
}

