/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreePanel;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.ImportsTableModel;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport.EmptyImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AddedPrefixesTable;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.prefixes.PrefixesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportsPanel
extends JPanel
implements Disposable {
    private Action addImportAction = new AbstractAction("Import ontology...", OWLIcons.getAddIcon("Import")){

        public void actionPerformed(ActionEvent actionEvent) {
            ImportsPanel.this.addImport();
        }
    };
    private Action createImportedTripleStoreAction = new AbstractAction("Create empty imported ontology...", OWLIcons.getCreateIcon("Import")){

        public void actionPerformed(ActionEvent actionEvent) {
            ImportsPanel.this.createImportedTripleStore();
        }
    };
    private Action showImportsTreeAction = new AbstractAction("Show imports tree", OWLIcons.getImageIcon("View")){

        public void actionPerformed(ActionEvent actionEvent) {
            ImportsTreePanel.showDialog(ImportsPanel.this.owlModel);
        }
    };
    private OWLModel owlModel;
    private PrefixesPanel prefixesPanel;
    private Action removeAction = new AbstractAction("Remove import", OWLIcons.getRemoveIcon("Import")){

        public void actionPerformed(ActionEvent actionEvent) {
            ImportsPanel.this.removeSelectedImport();
        }
    };
    private JTable table;
    private ImportsTableModel tableModel;

    public ImportsPanel(OWLOntology oWLOntology) {
        this.owlModel = oWLOntology.getOWLModel();
        this.tableModel = new ImportsTableModel(oWLOntology);
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.setLayout(new BorderLayout(0, 10));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Imports", jScrollPane);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        oWLLabeledComponent.addHeaderButton(this.createImportedTripleStoreAction);
        oWLLabeledComponent.addHeaderButton(this.addImportAction);
        oWLLabeledComponent.addHeaderButton(this.showImportsTreeAction);
        oWLLabeledComponent.addHeaderButton(this.removeAction);
        this.removeAction.setEnabled(false);
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ImportsPanel.this.enableActions();
                ImportsPanel.this.synchronizePrefixesPanel();
            }
        });
    }

    private void addImport() {
        try {
            ImportWizard importWizard = new ImportWizard((JComponent)this, this.owlModel);
            if (importWizard.execute() == 1) {
                ImportHelper importHelper = new ImportHelper((JenaOWLModel)this.owlModel);
                ArrayList<String> arrayList = new ArrayList<String>(this.owlModel.getNamespaceManager().getPrefixes());
                for (Object object : importWizard.getImportData().getImportEntries()) {
                    Repository repository = object.getRepositoryToAdd();
                    if (repository != null) {
                        this.owlModel.getRepositoryManager().addProjectRepository(object.getRepository());
                    }
                    URI uRI = object.getOntologyURI();
                    importHelper.addImport(uRI);
                }
                importHelper.importOntologies();
                ArrayList<String> arrayList2 = new ArrayList<String>(this.owlModel.getNamespaceManager().getPrefixes());
                arrayList2.removeAll(arrayList);
                if (arrayList2.size() > 0) {
                    Object object;
                    object = ProtegeUI.getTopLevelContainer(this.owlModel.getProject());
                    AddedPrefixesTable.showDialog((Component)object, this.owlModel, arrayList2);
                }
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }

    private void createImportedTripleStore() {
        EmptyImportWizard emptyImportWizard = new EmptyImportWizard((JComponent)this, this.owlModel);
        emptyImportWizard.execute();
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    private void enableActions() {
        boolean bl = this.table.getSelectedRow() >= 0 && this.table.getSelectedRow() < this.tableModel.getRowCount();
        this.removeAction.setEnabled(bl);
    }

    private void removeSelectedImport() {
        int n = this.table.getSelectedRow();
        if (n >= 0 && n < this.tableModel.getRowCount() && OWLUtil.confirmSaveAndReload(this.owlModel.getProject())) {
            this.tableModel.deleteRow(n);
            OWLUtil.saveAndReloadProject();
        }
    }

    public void setPrefixesPanel(PrefixesPanel prefixesPanel) {
        this.prefixesPanel = prefixesPanel;
    }

    public void setSelectedNamespace(String string) {
        int n;
        String string2 = string;
        if (Jena.isNamespaceWithSeparator(string)) {
            string2 = string.substring(0, string.length() - 1);
        }
        if ((n = this.tableModel.getURIRow(string2)) >= 0) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
    }

    private void synchronizePrefixesPanel() {
        int n;
        if (this.prefixesPanel != null && (n = this.table.getSelectedRow()) >= 0 && n < this.tableModel.getRowCount()) {
            String string = this.tableModel.getURI(n);
            this.prefixesPanel.setSelectedURI(string);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.table.setEnabled(bl);
        this.addImportAction.setEnabled(bl);
        this.createImportedTripleStoreAction.setEnabled(bl);
        this.showImportsTreeAction.setEnabled(bl);
        this.removeAction.setEnabled(bl);
    }
}

