/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OntologyURIWidget
extends AbstractPropertyWidget {
    private JTextField nameField;
    private static final String TOOL_TIP_TEXT = "<html><body>This specifies the name of the ontology (also known as the logical URI).<br>The name is a URI that other ontologies will use to import<br>this ontology.  It is recommended that it resembles a http URL that points<br>to the location where the ontology can be downloaded from.</html></body>";

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getName().equals(OWLNames.Cls.ONTOLOGY);
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.nameField = new JTextField();
        LabeledComponent labeledComponent = new LabeledComponent("Ontology URI", (Component)this.nameField);
        this.add((Component)labeledComponent, "North");
        this.nameField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    OntologyURIWidget.this.setDefaultOntology();
                }
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                OntologyURIWidget.this.setDefaultOntology();
            }
        });
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                OntologyURIWidget.this.validateName();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                OntologyURIWidget.this.validateName();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.nameField.setToolTipText(TOOL_TIP_TEXT);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.updateOntologyName();
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        this.updateOntologyName();
    }

    private boolean validateName() {
        if (this.nameField.getText().length() == 0) {
            return false;
        }
        try {
            new URI(this.nameField.getText());
            this.nameField.setForeground(Color.BLACK);
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.nameField.setForeground(Color.RED);
            return false;
        }
    }

    private void updateOntologyName() {
        OWLOntology oWLOntology = (OWLOntology)this.getEditedResource();
        if (oWLOntology != null) {
            this.nameField.setText(oWLOntology.getURI());
        }
    }

    private void setDefaultOntology() {
        if (this.validateName()) {
            OWLOntology oWLOntology = (OWLOntology)this.getEditedResource();
            oWLOntology.rename(this.nameField.getText());
            this.updateOntologyName();
        } else {
            this.updateOntologyName();
        }
    }

    protected boolean isOntologyNameEditable(Instance instance) {
        TripleStore tripleStore = this.getOWLModel().getTripleStoreModel().getActiveTripleStore();
        String string = tripleStore.getName();
        return string != null && string.equals(instance.getName());
    }

    public void setEnabled(boolean bl) {
        RDFResource rDFResource = this.getEditedResource();
        if (rDFResource != null) {
            bl = bl && this.isOntologyNameEditable(rDFResource);
        }
        this.nameField.setEnabled(bl);
        this.nameField.setEditable(bl);
        super.setEnabled(bl);
    }
}

