/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OntologyURIDefaultSettingsPanel
extends JPanel {
    private JTextField defaultURIBaseField;
    private JCheckBox yearCheckBox;
    private JCheckBox monthCheckBox;
    private JCheckBox dayCheckBox;
    private JTextField previewField;
    private static final String HELP_TEXT = "<p>These settings can be used to construct a default base<br>URI that is used each time a new project is created in Protege-OWL.</p><p><b>Ontology URI Base</b> is used as a prefix for the ontology URI</p><p><b>Append Year</b> includes the current year in the URI.</p><p><b>Append Month</b> includes the current month in the URI.</p><p><b>Append Day</b> includes the current day in the URI.</p>";

    public OntologyURIDefaultSettingsPanel(boolean bl) {
        this.createUI(bl);
    }

    private void createUI(boolean bl) {
        this.setLayout(new BorderLayout(12, 12));
        JPanel jPanel = new JPanel(new BorderLayout(7, 7));
        this.defaultURIBaseField = new JTextField();
        this.defaultURIBaseField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                OntologyURIDefaultSettingsPanel.this.updatePreviewState();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                OntologyURIDefaultSettingsPanel.this.updatePreviewState();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                OntologyURIDefaultSettingsPanel.this.updatePreviewState();
            }
        });
        LabeledComponent labeledComponent = new LabeledComponent("Ontology URI Domain and Path", (Component)this.defaultURIBaseField);
        jPanel.add((Component)labeledComponent, "North");
        Box box = new Box(1);
        box.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        this.yearCheckBox = new JCheckBox(new AbstractAction("Append year"){

            public void actionPerformed(ActionEvent actionEvent) {
                OntologyURIDefaultSettingsPanel.this.updateCheckBoxState();
            }
        });
        box.add(this.yearCheckBox);
        this.monthCheckBox = new JCheckBox(new AbstractAction("Append month"){

            public void actionPerformed(ActionEvent actionEvent) {
                OntologyURIDefaultSettingsPanel.this.updateCheckBoxState();
            }
        });
        box.add(this.monthCheckBox);
        this.dayCheckBox = new JCheckBox(new AbstractAction("Append day"){

            public void actionPerformed(ActionEvent actionEvent) {
                OntologyURIDefaultSettingsPanel.this.updateCheckBoxState();
            }
        });
        box.add(this.dayCheckBox);
        jPanel.add((Component)box, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout(7, 7));
        jPanel2.add((Component)jPanel, "North");
        this.previewField = new JTextField();
        this.previewField.setEditable(false);
        LabeledComponent labeledComponent2 = new LabeledComponent("Preview", (Component)this.previewField);
        jPanel2.add((Component)labeledComponent2, "South");
        this.add((Component)jPanel2, "North");
        if (bl) {
            this.add((Component)OWLUI.createHelpPanel(HELP_TEXT, "Ontology URI Default Settings"), "South");
        }
        this.updateUIFromAppProps();
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (OntologyURIDefaultSettingsPanel.this.isShowing()) {
                    OntologyURIDefaultSettingsPanel.this.defaultURIBaseField.requestFocus();
                    OntologyURIDefaultSettingsPanel.this.defaultURIBaseField.setCaretPosition(OntologyURIDefaultSettingsPanel.this.defaultURIBaseField.getText().length());
                }
            }
        });
    }

    private void updateUIFromAppProps() {
        this.defaultURIBaseField.setText(ApplicationProperties.getString((String)"OntURIBase"));
        this.yearCheckBox.setSelected(ApplicationProperties.getBooleanProperty((String)"OntURIBaseAppendYear", (boolean)false));
        this.monthCheckBox.setSelected(ApplicationProperties.getBooleanProperty((String)"OntURIBaseAppendMonth", (boolean)false));
        this.dayCheckBox.setSelected(ApplicationProperties.getBooleanProperty((String)"OntURIBaseAppendDay", (boolean)false));
        this.updateCheckBoxState();
    }

    private void updateAppPropsFromUI() {
        ApplicationProperties.setString((String)"OntURIBase", (String)this.defaultURIBaseField.getText());
        ApplicationProperties.setBoolean((String)"OntURIBaseAppendYear", (boolean)this.yearCheckBox.isSelected());
        ApplicationProperties.setBoolean((String)"OntURIBaseAppendMonth", (boolean)this.monthCheckBox.isSelected());
        ApplicationProperties.setBoolean((String)"OntURIBaseAppendDay", (boolean)this.dayCheckBox.isSelected());
    }

    private void updateCheckBoxState() {
        this.monthCheckBox.setEnabled(this.yearCheckBox.isSelected());
        if (!this.yearCheckBox.isSelected()) {
            this.monthCheckBox.setSelected(false);
        }
        this.dayCheckBox.setEnabled(this.monthCheckBox.isSelected());
        if (!this.monthCheckBox.isSelected()) {
            this.dayCheckBox.setSelected(false);
        }
        this.updatePreviewState();
    }

    private void updatePreviewState() {
        String string = this.defaultURIBaseField.getText();
        if ((string = FactoryUtils.getOntologyURIBase(string, this.yearCheckBox.isSelected(), this.monthCheckBox.isSelected(), this.dayCheckBox.isSelected())) != null) {
            this.previewField.setText(string);
        } else {
            this.previewField.setText("");
        }
    }

    public static void showDialog(Component component) {
        OntologyURIDefaultSettingsPanel ontologyURIDefaultSettingsPanel = new OntologyURIDefaultSettingsPanel(true);
        int n = ProtegeUI.getModalDialogFactory().showDialog(component, ontologyURIDefaultSettingsPanel, "Ontology URI Default Settings", 11);
        if (n == 1) {
            ontologyURIDefaultSettingsPanel.updateAppPropsFromUI();
        }
    }
}

