/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.server.metaproject.OwlMetaProjectConstants;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreePanel;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractTabWidget;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;

public class OWLMetadataTab
extends AbstractTabWidget
implements HostResourceDisplay {
    private ResourcePanel resourceDisplay;
    private ImportsTreePanel importsTreePanel;
    private SelectionListener treeSelectionListener;
    private FrameListener frameListener;

    private JComponent createMainPanel() {
        this.treeSelectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                Set set = OWLMetadataTab.this.importsTreePanel.getImportsTree().getSelectedResources();
                RDFResource rDFResource = (RDFResource)CollectionUtilities.getFirstItem((Collection)set);
                OWLMetadataTab.this.resourceDisplay.setResource(rDFResource);
                ((ResourceDisplay)OWLMetadataTab.this.resourceDisplay).setEnabled(OWLMetadataTab.this.isEnabled());
            }
        };
        this.importsTreePanel = new ImportsTreePanel(this.getOWLModel().getDefaultOWLOntology());
        this.importsTreePanel.getImportsTree().addSelectionListener(this.treeSelectionListener);
        this.resourceDisplay = ProtegeUI.getResourcePanelFactory().createResourcePanel(this.getOWLModel(), 3);
        OWLOntology oWLOntology = OWLUtil.getActiveOntology(this.getOWLModel());
        if (oWLOntology != null) {
            this.displayHostResource(oWLOntology);
        }
        JSplitPane jSplitPane = this.createLeftRightSplitPane("SlotsTab.left_right", 250);
        jSplitPane.setLeftComponent(this.importsTreePanel);
        jSplitPane.setRightComponent((Component)((Object)this.resourceDisplay));
        jSplitPane.setDividerLocation(250);
        return jSplitPane;
    }

    public void dispose() {
        super.dispose();
        this.importsTreePanel.getImportsTree().removeSelectionListener(this.treeSelectionListener);
        this.treeSelectionListener = null;
        try {
            this.removeFrameListner();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at removing frame listener from " + this.getOWLModel().getDefaultOWLOntology(), exception);
        }
        this.importsTreePanel.dispose();
        this.resourceDisplay.dispose();
    }

    public void initialize() {
        this.setIcon(OWLIcons.getImageIcon("Metadata"));
        JComponent jComponent = this.createMainPanel();
        this.add(jComponent);
        this.setClsTree((JTree)((Object)this.importsTreePanel.getImportsTree()));
        this.setEnabled(true);
        this.addFrameListener();
    }

    protected void addFrameListener() {
        this.frameListener = new FrameAdapter(){

            public void frameReplaced(FrameEvent frameEvent) {
                OWLMetadataTab.this.setLabel(OWLMetadataTab.this.getLabel());
                try {
                    JTabbedPane jTabbedPane = ProjectManager.getProjectManager().getCurrentProjectView().getTabbedPane();
                    int n = jTabbedPane.indexOfComponent((Component)((Object)OWLMetadataTab.this));
                    jTabbedPane.setTitleAt(n, OWLMetadataTab.this.getLabel());
                }
                catch (Exception exception) {
                    Log.emptyCatchBlock((Throwable)exception);
                }
                OWLMetadataTab.this.repaint();
            }
        };
        this.getOWLModel().getDefaultOWLOntology().addFrameListener(this.frameListener);
    }

    protected void removeFrameListner() {
        if (this.frameListener != null) {
            this.getOWLModel().getDefaultOWLOntology().removeFrameListener(this.frameListener);
        }
    }

    public String getLabel() {
        OWLOntology oWLOntology = OWLUtil.getActiveOntology(this.getOWLModel());
        if (oWLOntology != null) {
            return "Metadata(" + NamespaceUtil.getLocalName(oWLOntology.getName()) + ")";
        }
        return "Metadata(Unknown ontology name)";
    }

    public static boolean isSuitable(Project project, Collection collection) {
        if (!(project.getKnowledgeBase() instanceof OWLModel)) {
            collection.add("This tab can only be used with OWL projects.");
            return false;
        }
        return true;
    }

    @Deprecated
    public void setOntologyInstance(OWLOntology oWLOntology) {
        this.setOntology(oWLOntology);
    }

    public void setOntology(OWLOntology oWLOntology) {
        this.displayHostResource(oWLOntology);
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        return this.importsTreePanel.displayHostResource(rDFResource);
    }

    public void setEnabled(boolean bl) {
        bl = bl && RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)this.getOWLModel(), (Operation)OwlMetaProjectConstants.OPERATION_ONTOLOGY_TAB_WRITE);
        ((ResourceDisplay)this.resourceDisplay).setEnabled(bl);
        this.importsTreePanel.setEnabled(bl);
        super.setEnabled(bl);
    }
}

