/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadata;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.HTMLEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AnnotationTextAreaWidget
extends AbstractPropertyWidget {
    private RDFProperty annotationProperty;
    private Action editHTMLAction = new AbstractAction("Edit as HTML...", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationTextAreaWidget.this.editAsHTML();
        }
    };
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            if (rDFProperty.equals(AnnotationTextAreaWidget.this.annotationProperty)) {
                AnnotationTextAreaWidget.this.resetEditedValue();
            }
        }
    };
    private OWLLabeledComponent labeledComponent;
    private Object oldValue;
    private JTextArea textArea;

    private void assignCurrentValue() {
        RDFResource rDFResource = this.getEditedResource();
        if (rDFResource != null && this.annotationProperty != null) {
            String string = this.textArea.getText();
            if (!string.equals(this.oldValue)) {
                this.assignValue(string, rDFResource);
            }
        } else {
            this.oldValue = null;
        }
    }

    private void assignValue(String string, RDFResource rDFResource) {
        Object object = null;
        object = this.oldValue instanceof RDFSLiteral ? this.getOWLModel().createRDFSLiteralOrString(string, ((RDFSLiteral)this.oldValue).getLanguage()) : string;
        if (!this.getEditedResource().getPropertyValues(this.annotationProperty).contains(object) && !AnnotationsTableModel.isInvalidXMLLiteral(this.getRDFProperty(), object)) {
            Collection collection = rDFResource.getPropertyValues(this.annotationProperty);
            ArrayList<Object> arrayList = new ArrayList<Object>(collection);
            int n = arrayList.indexOf(this.oldValue);
            if (string.length() > 0) {
                if (n >= 0) {
                    arrayList.set(n, object);
                } else {
                    arrayList.add(object);
                }
                rDFResource.setPropertyValues(this.annotationProperty, arrayList);
                this.oldValue = object;
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.unregisterFrameListener();
    }

    private void editAsHTML() {
        if (XMLSchemaDatatypes.isXMLLiteralSlot(this.getRDFProperty())) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.getOWLModel(), "This HTML editor does not support XMLLiterals yet.");
        } else {
            String string = this.textArea.getText();
            String string2 = HTMLEditorPanel.show((Component)((Object)this), string, "Edit " + this.getRDFProperty().getBrowserText() + " at " + this.getEditedResource().getBrowserText());
            if (string2 != null && !string.equals(string2)) {
                this.assignValue(string2, this.getEditedResource());
            }
        }
    }

    public void initialize() {
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                AnnotationTextAreaWidget.this.assignCurrentValue();
            }
        });
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                    AnnotationTextAreaWidget.this.getParent().requestFocus();
                }
            }
        });
        this.labeledComponent = new OWLLabeledComponent("http://www.w3.org/2000/01/rdf-schema#comment", new JScrollPane(this.textArea));
        this.labeledComponent.addHeaderButton(this.editHTMLAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)this.labeledComponent));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getKnowledgeBase() instanceof OWLModel && slot.getName().equals("http://www.w3.org/2000/01/rdf-schema#comment");
    }

    public void resetEditedValue() {
        OWLDatatypeProperty oWLDatatypeProperty = this.getOWLModel().getRDFSCommentProperty();
        String string = null;
        String string2 = this.getOWLModel().getDefaultLanguage();
        String string3 = "" + string2;
        Object var5_5 = null;
        for (Object e : this.getEditedResource().getPropertyValues(oWLDatatypeProperty)) {
            String string4;
            String string5 = string4 = e instanceof RDFSLiteral ? ((RDFSLiteral)e).getLanguage() : null;
            if (!string3.equals("" + string4)) continue;
            string = e instanceof RDFSLiteral ? ((RDFSLiteral)e).getString() : e.toString();
            var5_5 = e;
            break;
        }
        this.setEditedValueInternal(oWLDatatypeProperty, string, string2, var5_5);
    }

    public void setEditedValue(OWLDatatypeProperty oWLDatatypeProperty, String string, String string2, Object object) {
        this.assignCurrentValue();
        this.setEditedValueInternal(oWLDatatypeProperty, string, string2, object);
    }

    private void setEditedValueInternal(OWLDatatypeProperty oWLDatatypeProperty, String string, String string2, Object object) {
        if (string == null) {
            string = "";
        }
        this.annotationProperty = oWLDatatypeProperty;
        String string3 = oWLDatatypeProperty.getBrowserText();
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + " (" + string2 + ")";
        }
        this.labeledComponent.setHeaderLabel(string3);
        this.oldValue = oWLDatatypeProperty.getOWLModel().createRDFSLiteralOrString(string, string2);
        this.textArea.setText(string);
        boolean bl = false;
        if (!oWLDatatypeProperty.isReadOnly()) {
            if (object == null) {
                bl = true;
            } else {
                TripleStoreModel tripleStoreModel = this.getOWLModel().getTripleStoreModel();
                bl = tripleStoreModel.isActiveTriple(this.getEditedResource(), oWLDatatypeProperty, object);
            }
        }
        this.textArea.setEditable(bl);
        this.editHTMLAction.setEnabled(bl);
    }

    public void setInstance(Instance instance) {
        this.unregisterFrameListener();
        this.assignCurrentValue();
        super.setInstance(instance);
        if (instance instanceof RDFResource) {
            ((RDFResource)instance).addPropertyValueListener(this.valueListener);
        }
        this.resetEditedValue();
    }

    private void unregisterFrameListener() {
        if (this.getEditedResource() != null) {
            this.getEditedResource().removePropertyValueListener(this.valueListener);
        }
    }
}

