/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protegex.owl.jena.writersettings.JenaWriterSettings;
import edu.stanford.smi.protegex.owl.jena.writersettings.WriterSettings;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.ProtegeWriterSettings;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WriterSettingsPanel
extends JComponent {
    private OWLModel owlModel;
    private JRadioButton jenaButton;
    private JRadioButton protegeButton;
    private JCheckBox sortAlphabeticallyBox;
    private WriterSettings writerSettings;
    private JCheckBox useXMLEntitiesBox;

    public WriterSettingsPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.jenaButton = new JRadioButton("Default Jena writer");
        this.protegeButton = new JRadioButton("Native writer");
        this.writerSettings = oWLModel.getWriterSettings();
        if (this.writerSettings instanceof JenaWriterSettings) {
            this.jenaButton.setSelected(true);
        } else {
            this.protegeButton.setSelected(true);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jenaButton);
        buttonGroup.add(this.protegeButton);
        this.sortAlphabeticallyBox = new JCheckBox("Sort resources alphabetically");
        this.sortAlphabeticallyBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WriterSettingsPanel.this.setSortAlphabetically(WriterSettingsPanel.this.sortAlphabeticallyBox.isSelected());
            }
        });
        this.useXMLEntitiesBox = new JCheckBox("Use XML entities");
        this.useXMLEntitiesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WriterSettingsPanel.this.setUseXMLEntities(WriterSettingsPanel.this.useXMLEntitiesBox.isSelected());
            }
        });
        this.jenaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WriterSettingsPanel.this.setJenaWriterSettings();
            }
        });
        this.protegeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WriterSettingsPanel.this.setProtegeWriterSettings();
            }
        });
        JPanel jPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder("RDF/XML Writer Settings"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.jenaButton);
        jPanel.add(this.protegeButton);
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.add(this.useXMLEntitiesBox);
        box.add(this.sortAlphabeticallyBox);
        this.updateProtegePanel();
        this.add("West", jPanel);
        this.add("Center", new JPanel());
        this.add("East", box);
    }

    private void setJenaWriterSettings() {
        this.owlModel.setWriterSettings(new JenaWriterSettings(this.owlModel));
        this.updateProtegePanel();
    }

    private void setProtegeWriterSettings() {
        this.owlModel.setWriterSettings(new ProtegeWriterSettings(this.owlModel));
        this.updateProtegePanel();
    }

    private void setSortAlphabetically(boolean bl) {
        ProtegeWriterSettings protegeWriterSettings = (ProtegeWriterSettings)this.owlModel.getWriterSettings();
        protegeWriterSettings.setSortAlphabetically(bl);
    }

    private void setUseXMLEntities(boolean bl) {
        ProtegeWriterSettings protegeWriterSettings = (ProtegeWriterSettings)this.owlModel.getWriterSettings();
        protegeWriterSettings.setUseXMLEntities(bl);
    }

    private void updateProtegePanel() {
        WriterSettings writerSettings = this.owlModel.getWriterSettings();
        boolean bl = writerSettings instanceof ProtegeWriterSettings;
        if (bl) {
            ProtegeWriterSettings protegeWriterSettings = (ProtegeWriterSettings)writerSettings;
            this.sortAlphabeticallyBox.setSelected(protegeWriterSettings.isSortAlphabetically());
            this.useXMLEntitiesBox.setSelected(protegeWriterSettings.getUseXMLEntities());
        }
        this.sortAlphabeticallyBox.setEnabled(bl);
        this.useXMLEntitiesBox.setEnabled(bl);
    }
}

