/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class VisibilityPanel
extends JComponent {
    private boolean requiresReloadUI;

    public VisibilityPanel(OWLModel oWLModel) {
        Cls[] clsArray = new Cls[]{oWLModel.getRDFSNamedClassClass(), oWLModel.getOWLNamedClassClass(), oWLModel.getRDFPropertyClass(), oWLModel.getOWLDatatypePropertyClass(), oWLModel.getOWLObjectPropertyClass(), oWLModel.getRDFSNamedClass(OWLNames.Cls.ANNOTATION_PROPERTY), oWLModel.getRDFSNamedClass(OWLNames.Cls.DEPRECATED_CLASS), oWLModel.getRDFSNamedClass(OWLNames.Cls.DEPRECATED_PROPERTY), oWLModel.getRDFSNamedClass(OWLNames.Cls.FUNCTIONAL_PROPERTY), oWLModel.getRDFSNamedClass(OWLNames.Cls.INVERSE_FUNCTIONAL_PROPERTY), oWLModel.getRDFSNamedClass(OWLNames.Cls.SYMMETRIC_PROPERTY), oWLModel.getRDFSNamedClass(OWLNames.Cls.TRANSITIVE_PROPERTY)};
        Cls[] clsArray2 = new Cls[]{oWLModel.getRDFSNamedClass("http://www.w3.org/2000/01/rdf-schema#Datatype"), oWLModel.getRDFListClass(), oWLModel.getRDFSNamedClass("http://www.w3.org/2000/01/rdf-schema#Container"), oWLModel.getRDFSNamedClass(RDFNames.Cls.ALT), oWLModel.getRDFSNamedClass(RDFNames.Cls.BAG), oWLModel.getRDFSNamedClass(RDFNames.Cls.SEQ), oWLModel.getRDFSNamedClass(RDFNames.Cls.STATEMENT), oWLModel.getRDFSNamedClass(OWLNames.Cls.ALL_DIFFERENT), oWLModel.getOWLNothing(), oWLModel.getOWLDataRangeClass()};
        Instance[] instanceArray = new RDFProperty[]{oWLModel.getRDFProperty(RDFNames.Slot.FIRST), oWLModel.getRDFProperty(RDFNames.Slot.REST), oWLModel.getRDFProperty("http://www.w3.org/2000/01/rdf-schema#range"), oWLModel.getRDFProperty("http://www.w3.org/2000/01/rdf-schema#member"), oWLModel.getRDFProperty(RDFNames.Slot.TYPE), oWLModel.getRDFProperty(RDFNames.Slot.OBJECT), oWLModel.getRDFProperty(RDFNames.Slot.PREDICATE), oWLModel.getRDFProperty(RDFNames.Slot.SUBJECT), oWLModel.getRDFProperty(RDFNames.Slot.VALUE)};
        Instance[] instanceArray2 = new RDFProperty[]{oWLModel.getRDFProperty(OWLNames.Slot.SAME_AS), oWLModel.getRDFProperty(OWLNames.Slot.DIFFERENT_FROM), oWLModel.getRDFProperty(OWLNames.Slot.DISJOINT_WITH), oWLModel.getRDFProperty(OWLNames.Slot.DISTINCT_MEMBERS), oWLModel.getRDFProperty(OWLNames.Slot.ALL_VALUES_FROM), oWLModel.getRDFProperty(OWLNames.Slot.SOME_VALUES_FROM), oWLModel.getRDFProperty(OWLNames.Slot.HAS_VALUE), oWLModel.getRDFProperty(OWLNames.Slot.CARDINALITY), oWLModel.getRDFProperty(OWLNames.Slot.MIN_CARDINALITY), oWLModel.getRDFProperty(OWLNames.Slot.MAX_CARDINALITY), oWLModel.getRDFProperty(OWLNames.Slot.ONE_OF), oWLModel.getRDFProperty(OWLNames.Slot.ON_PROPERTY)};
        Instance[] instanceArray3 = new Instance[]{oWLModel.getSystemFrames().getDirectedBinaryRelationCls(), oWLModel.getSystemFrames().getFromSlot(), oWLModel.getSystemFrames().getToSlot()};
        Component component = this.createCheckBoxesPanel("Metaclasses", (Instance[])clsArray);
        Component component2 = this.createCheckBoxesPanel("Other Classes", (Instance[])clsArray2);
        Component component3 = this.createCheckBoxesPanel("RDF Properties", instanceArray);
        Component component4 = this.createCheckBoxesPanel("OWL Properties", instanceArray2);
        Component component5 = this.createCheckBoxesPanel("Native Protege Resources", instanceArray3);
        Component component6 = this.createCheckBoxesPanel("Annotation Properties", oWLModel.getSystemAnnotationProperties());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", component);
        jPanel.add("South", component2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", component3);
        jPanel2.add("South", component4);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", component6);
        jPanel3.add("Center", component5);
        this.setLayout(new GridLayout(1, 3));
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
    }

    private Component createCheckBoxesPanel(String string, Instance[] instanceArray) {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        for (int i = 0; i < instanceArray.length; ++i) {
            object = instanceArray[i];
            jPanel.add(new VisibilityCheckBox((Instance)object));
        }
        AllCheckBox allCheckBox = new AllCheckBox(jPanel);
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(string));
        ((Container)object).add("North", allCheckBox);
        ((Container)object).add("West", Box.createHorizontalStrut(12));
        ((Container)object).add("Center", jPanel);
        return object;
    }

    public boolean getRequiresReloadUI() {
        return this.requiresReloadUI;
    }

    private class VisibilityCheckBox
    extends JCheckBox {
        private Instance instance;

        VisibilityCheckBox(Instance instance) {
            super(instance.getBrowserText(), instance.isVisible());
            this.instance = instance;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VisibilityCheckBox.this.updateVisibility();
                }
            });
        }

        Instance getInstance() {
            return this.instance;
        }

        private void updateVisibility() {
            boolean bl = this.isSelected();
            this.instance.setVisible(bl);
            if (this.instance instanceof Cls) {
                Cls cls = (Cls)this.instance;
                Collection collection = bl ? cls.getSuperclasses() : cls.getSubclasses();
                this.setDependentCheckBoxesSelected(collection, bl);
            }
            VisibilityPanel.this.requiresReloadUI = true;
        }

        private void setDependentCheckBoxesSelected(Collection collection, boolean bl) {
            for (Cls cls : collection) {
                if (cls instanceof RDFSClass) {
                    cls.setVisible(bl);
                }
                Container container = this.getParent();
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    if (!(container.getComponent(i) instanceof VisibilityCheckBox)) continue;
                    VisibilityCheckBox visibilityCheckBox = (VisibilityCheckBox)container.getComponent(i);
                    if (!cls.equals(visibilityCheckBox.instance)) continue;
                    visibilityCheckBox.setSelected(bl);
                }
            }
        }
    }

    private class AllCheckBox
    extends JCheckBox {
        private Container container;

        AllCheckBox(Container container) {
            super("All");
            this.container = container;
            this.setSelected(this.isAllSelected());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AllCheckBox.this.updateDependents();
                    VisibilityPanel.this.requiresReloadUI = true;
                }
            });
        }

        private boolean isAllSelected() {
            for (int i = 0; i < this.container.getComponentCount(); ++i) {
                VisibilityCheckBox visibilityCheckBox;
                if (!(this.container.getComponent(i) instanceof VisibilityCheckBox) || (visibilityCheckBox = (VisibilityCheckBox)this.container.getComponent(i)).isSelected()) continue;
                return false;
            }
            return true;
        }

        private void updateDependents() {
            boolean bl = this.isSelected();
            for (int i = 0; i < this.container.getComponentCount(); ++i) {
                if (!(this.container.getComponent(i) instanceof VisibilityCheckBox)) continue;
                VisibilityCheckBox visibilityCheckBox = (VisibilityCheckBox)this.container.getComponent(i);
                visibilityCheckBox.setSelected(bl);
                visibilityCheckBox.getInstance().setVisible(bl);
            }
        }
    }
}

