/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class RenderingPanel
extends JPanel {
    private static final long serialVersionUID = -2021694698732430578L;
    public static String RENDERING_PANEL_TITLE = "Rendering";
    public static String DEFAULT_BROWSER_SLOT_PROP = "owl.default.browser.slot";
    public static String DEFAULT_LANGUATE_PROPERTY = "owl.default.language.slot";
    public static String[] META_SLOT_NAMES = new String[]{OWLNames.Cls.NAMED_CLASS, "http://www.w3.org/2000/01/rdf-schema#Class", RDFNames.Cls.PROPERTY, OWLNames.Cls.THING};
    private OWLModel owlModel;
    private JComboBox renderingPropertyBox;
    private JComboBox defaultRenderingPropertyBox;
    private JTextField defaultLanguageField;
    private boolean requiresReloadUI = false;

    public RenderingPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.setLayout(new BoxLayout(this, 3));
        this.setAlignmentX(0.0f);
        this.setBorder(BorderFactory.createTitledBorder(RENDERING_PANEL_TITLE));
        this.add(this.getLocalSettingsPanel());
        this.add(Box.createVerticalStrut(10));
        this.add(this.getGlobalSettingsPanel());
    }

    public boolean getRequiresReloadUI() {
        return this.requiresReloadUI;
    }

    private JComponent getLocalSettingsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createTitledBorder("Local Settings"));
        jPanel.setAlignmentX(0.0f);
        jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 80));
        this.renderingPropertyBox = this.makePropertyComboBox(OWLUI.getCommonBrowserSlot(this.owlModel));
        this.renderingPropertyBox.setAlignmentX(0.0f);
        this.renderingPropertyBox.addActionListener(new SetRendererActionListener());
        jPanel.add((Component)new LabeledComponent("Render entities in this ontology (" + this.getOntologyName() + ") using property: ", (Component)this.renderingPropertyBox));
        jPanel.setToolTipText("The local setting will apply only to the current ontology and it will be saved in the pprj file.");
        return jPanel;
    }

    private JComponent getGlobalSettingsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createTitledBorder("Global Settings"));
        jPanel.setAlignmentX(0.0f);
        jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 210));
        this.defaultRenderingPropertyBox = this.makePropertyComboBox(OWLUI.getDefaultBrowserSlot(this.owlModel));
        this.defaultRenderingPropertyBox.setAlignmentX(0.0f);
        this.defaultRenderingPropertyBox.addActionListener(new SetDefaultRendererActionListener());
        jPanel.add((Component)new LabeledComponent("Render entities in all OWL files using property:", (Component)this.defaultRenderingPropertyBox));
        this.defaultLanguageField = this.makeDefaultLanguageField();
        this.defaultLanguageField.setAlignmentX(0.0f);
        this.defaultLanguageField.getDocument().addDocumentListener(new SetLanguageDocumentListener());
        jPanel.add((Component)new LabeledComponent("Global default language for all OWL files (en, pt, de, ...):", (Component)this.defaultLanguageField));
        jPanel.setToolTipText("<html>The global settings will apply to all ontologies open by an OWL file (and not to the ones open by a pprj file).<br>The global settings will be saved in the protege.properties file.<html>");
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.getExplanationTextArea());
        return jPanel;
    }

    private JComponent getExplanationTextArea() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setBorder(BorderFactory.createTitledBorder("Explanation"));
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.setEditorKit(new HTMLEditorKit());
        Font font = UIManager.getFont("Label.font");
        String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)jEditorPane.getDocument()).getStyleSheet().addRule(string);
        String string2 = this.getDefaultLanguageSetInFile();
        String string3 = "<html>The global settings will apply to all ontologies open by an OWL file (and not to the ones open by a pprj file).<br>The global language setting will overide the default language set in the ontology file.<br><br>The current language set in the ontology file is:<b>" + (string2 == null ? "(none)" : string2) + "</b>.</html>";
        jEditorPane.setText(string3);
        return new JScrollPane(jEditorPane);
    }

    private JComboBox makePropertyComboBox(Slot slot) {
        TreeSet<RDFProperty> treeSet = new TreeSet<RDFProperty>(this.owlModel.getOWLAnnotationProperties());
        treeSet.remove(this.owlModel.getRDFSLabelProperty());
        Slot[] slotArray = new Slot[treeSet.size() + 2];
        int n = 0;
        slotArray[n++] = this.owlModel.getNameSlot();
        slotArray[n++] = this.owlModel.getRDFSLabelProperty();
        for (RDFProperty rDFProperty : treeSet) {
            slotArray[n++] = rDFProperty;
        }
        JComboBox<Slot> jComboBox = new JComboBox<Slot>(slotArray);
        jComboBox.setRenderer((ListCellRenderer<Slot>)((Object)new ComboBoxRenderer()));
        if (slot != null && (treeSet.contains(slot) || slot.equals(this.owlModel.getNameSlot()) || slot.equals(this.owlModel.getRDFSLabelProperty()))) {
            jComboBox.setSelectedItem(slot);
        } else {
            jComboBox.setSelectedIndex(-1);
        }
        return jComboBox;
    }

    private JTextField makeDefaultLanguageField() {
        JTextField jTextField = new JTextField();
        String string = ApplicationProperties.getString((String)DEFAULT_LANGUATE_PROPERTY);
        if (string != null) {
            jTextField.setText(string);
        }
        return jTextField;
    }

    private String getOntologyName() {
        OWLOntology oWLOntology = OWLUtil.getActiveOntology(this.owlModel);
        return NamespaceUtil.getLocalName(oWLOntology.getName());
    }

    private String getDefaultLanguageSetInFile() {
        String string;
        Object object;
        OWLOntology oWLOntology;
        String string2 = null;
        RDFProperty rDFProperty = this.owlModel.getRDFProperty(ProtegeNames.getDefaultLanguageSlotName());
        if (rDFProperty != null && (oWLOntology = this.owlModel.getDefaultOWLOntology()) != null && (object = oWLOntology.getPropertyValue(rDFProperty)) instanceof String && (string = (String)object) != null && string.length() > 0) {
            string2 = string;
        }
        return string2;
    }

    private class SetLanguageDocumentListener
    implements DocumentListener {
        private SetLanguageDocumentListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.saveContents();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.saveContents();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.saveContents();
        }

        private void saveContents() {
            String string = RenderingPanel.this.defaultLanguageField.getText();
            if (string != null) {
                string = string.trim();
            }
            ApplicationProperties.setString((String)DEFAULT_LANGUATE_PROPERTY, string == null || string.equals("") ? null : string);
        }
    }

    private class SetDefaultRendererActionListener
    implements ActionListener {
        private SetDefaultRendererActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Slot slot = (Slot)RenderingPanel.this.defaultRenderingPropertyBox.getSelectedItem();
            OWLUI.setDefaultBrowserSlot(RenderingPanel.this.owlModel, slot);
        }
    }

    private class SetRendererActionListener
    implements ActionListener {
        private SetRendererActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Slot slot = (Slot)RenderingPanel.this.renderingPropertyBox.getSelectedItem();
            OWLUI.setCommonBrowserSlot(RenderingPanel.this.owlModel, slot);
            RenderingPanel.this.requiresReloadUI = true;
        }
    }

    private class ComboBoxRenderer
    extends ResourceRenderer {
        private static final long serialVersionUID = -964343376627678218L;

        private ComboBoxRenderer() {
        }

        protected void loadSlot(Slot slot) {
            if (slot.equals(RenderingPanel.this.owlModel.getSystemFrames().getNameSlot())) {
                this.addText("rdf:id");
            } else {
                super.loadSlot(slot);
            }
        }
    }
}

