/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class ProtegeSettingsPanel
extends JComponent {
    private OWLModel owlModel;
    private JCheckBox importMetaCBox;
    private JCheckBox userDatatypesCBox;
    public static final String USER_DEFINED_DATATYPES = "edu.stanford.smi.protegex.owl.userDefinedDatatypes";

    ProtegeSettingsPanel(final JenaOWLModel jenaOWLModel) {
        this.owlModel = jenaOWLModel;
        this.importMetaCBox = new JCheckBox("Import Protege metadata ontology");
        this.importMetaCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProtegeSettingsPanel.this.importMetaCBox.isSelected()) {
                    ProtegeSettingsPanel.this.enableProtegeOntology();
                } else {
                    ProtegeSettingsPanel.this.disableProtegeOntology();
                }
            }
        });
        if (jenaOWLModel.isProtegeMetaOntologyImported()) {
            this.importMetaCBox.setSelected(true);
            if (!this.isMetadataOntologyImportedDirectly(OWLUtil.getActiveOntology(jenaOWLModel))) {
                this.importMetaCBox.setEnabled(false);
            }
        }
        this.userDatatypesCBox = new JCheckBox("Support user-defined XML Schema datatypes (numeric ranges)");
        this.userDatatypesCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProtegeSettingsPanel.setUserDefinedDatatypesSupported(jenaOWLModel, ProtegeSettingsPanel.this.userDatatypesCBox.isSelected());
                ProtegeUI.reloadUI(jenaOWLModel);
            }
        });
        this.userDatatypesCBox.setEnabled(this.importMetaCBox.isSelected());
        this.userDatatypesCBox.setSelected(ProtegeSettingsPanel.isUserDefinedDatatypesSupported(jenaOWLModel));
        this.setBorder(BorderFactory.createTitledBorder("Protege Features"));
        this.setLayout(new GridLayout(2, 1));
        this.add(this.importMetaCBox);
        this.add(this.userDatatypesCBox);
    }

    private void disableProtegeOntology() {
        if (OWLUtil.confirmSaveAndReload(this.owlModel.getProject())) {
            this.owlModel.getDefaultOWLOntology().removeImports(ProtegeNames.PROTEGE_OWL_ONTOLOGY);
            OWLUtil.saveAndReloadProject();
        }
        this.userDatatypesCBox.setSelected(false);
        this.userDatatypesCBox.setEnabled(false);
    }

    private void enableProtegeOntology() {
        if (!this.owlModel.isProtegeMetaOntologyImported()) {
            ImportHelper importHelper = new ImportHelper((JenaOWLModel)this.owlModel);
            try {
                URI uRI = new URI(ProtegeNames.PROTEGE_OWL_ONTOLOGY);
                importHelper.addImport(uRI);
                importHelper.importOntologies();
                this.owlModel.getNamespaceManager().setPrefix(ProtegeNames.PROTEGE_OWL_NAMESPACE, ProtegeNames.PROTEGE_PREFIX);
                this.userDatatypesCBox.setEnabled(true);
            }
            catch (Exception exception) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, exception.getMessage());
            }
        }
    }

    public static boolean isUserDefinedDatatypesSupported(OWLModel oWLModel) {
        return Boolean.TRUE.equals(oWLModel.getOWLProject().getSettingsMap().getBoolean(USER_DEFINED_DATATYPES));
    }

    public static void setUserDefinedDatatypesSupported(OWLModel oWLModel, boolean bl) {
        oWLModel.getOWLProject().getSettingsMap().setBoolean(USER_DEFINED_DATATYPES, (Boolean)bl);
    }

    private boolean isMetadataOntologyImportedDirectly(OWLOntology oWLOntology) {
        return oWLOntology.getImportResources().contains(this.getMetadataOnt());
    }

    private RDFResource getMetadataOnt() {
        RDFResource rDFResource = null;
        try {
            URI uRI = new URI(ProtegeNames.PROTEGE_OWL_ONTOLOGY);
            rDFResource = this.owlModel.getOWLOntologyByURI(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
        return rDFResource;
    }
}

