/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.project.SettingsMap;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsGenerator;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class FormsSettingsPanel
extends JPanel {
    private OWLModel owlModel;
    private JCheckBox saveFormsBox;
    private JCheckBox saveAllBox;

    public FormsSettingsPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.setBorder(BorderFactory.createTitledBorder("Forms"));
        this.saveFormsBox = new JCheckBox("Save forms to .forms files");
        this.saveFormsBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormsSettingsPanel.this.updateSettingsMap();
            }
        });
        this.saveAllBox = new JCheckBox("Also save uncustomized forms");
        this.saveAllBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormsSettingsPanel.this.updateSettingsMap();
            }
        });
        String string = this.getSettingsMap().getString(AbsoluteFormsGenerator.SAVE_FORMS_KEY);
        if ("modified".equals(string)) {
            this.saveFormsBox.setSelected(true);
            this.saveAllBox.setEnabled(true);
        } else if ("all".equals(string)) {
            this.saveFormsBox.setSelected(true);
            this.saveAllBox.setSelected(true);
            this.saveAllBox.setEnabled(true);
        } else {
            this.saveAllBox.setEnabled(false);
        }
        this.setLayout(new GridLayout(2, 1));
        this.add(this.saveFormsBox);
        this.add(this.saveAllBox);
    }

    private SettingsMap getSettingsMap() {
        return this.owlModel.getOWLProject().getSettingsMap();
    }

    private void updateSettingsMap() {
        SettingsMap settingsMap = this.getSettingsMap();
        String string = null;
        boolean bl = this.saveFormsBox.isSelected();
        this.saveAllBox.setEnabled(bl);
        if (bl) {
            string = this.saveAllBox.isSelected() ? "all" : "modified";
        }
        settingsMap.setString(AbsoluteFormsGenerator.SAVE_FORMS_KEY, string);
    }
}

