/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import com.hp.hpl.jena.vocabulary.XSD;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.ui.ResourceComparator;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class DatatypeSettingsPanel
extends JPanel {
    private boolean changed = false;
    private OWLModel owlModel;

    public DatatypeSettingsPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder("Visibility"));
        ArrayList<RDFSDatatype> arrayList = new ArrayList<RDFSDatatype>();
        for (RDFSDatatype object2 : oWLModel.getRDFSDatatypes()) {
            if (!object2.isSystem()) continue;
            arrayList.add(object2);
        }
        Box box = this.createBox("Default Types", arrayList, new RDFSDatatype[]{oWLModel.getXSDboolean(), oWLModel.getXSDfloat(), oWLModel.getXSDint(), oWLModel.getXSDstring()});
        Box box2 = this.createBox("Date/Time Types", arrayList, new RDFSDatatype[]{oWLModel.getXSDdate(), oWLModel.getXSDdateTime(), oWLModel.getXSDduration(), oWLModel.getXSDtime()});
        Box box3 = this.createBox("Uncommon Numeric Types", arrayList, new RDFSDatatype[]{oWLModel.getXSDbyte(), oWLModel.getXSDdecimal(), oWLModel.getXSDdouble(), oWLModel.getRDFSDatatypeByURI(XSD.integer.getURI()), oWLModel.getXSDlong(), oWLModel.getRDFSDatatypeByURI(XSD.negativeInteger.getURI()), oWLModel.getRDFSDatatypeByURI(XSD.nonNegativeInteger.getURI()), oWLModel.getRDFSDatatypeByURI(XSD.nonPositiveInteger.getURI()), oWLModel.getRDFSDatatypeByURI(XSD.positiveInteger.getURI()), oWLModel.getRDFSDatatypeByURI(XSD.unsignedByte.getURI()), oWLModel.getRDFSDatatypeByURI(XSD.unsignedInt.getURI()), oWLModel.getRDFSDatatypeByURI(XSD.unsignedLong.getURI()), oWLModel.getRDFSDatatypeByURI(XSD.unsignedShort.getURI()), oWLModel.getXSDshort()});
        Collections.sort(arrayList, new ResourceComparator());
        Box box4 = this.createBox("Other Types", arrayList, arrayList.toArray(new RDFSDatatype[0]));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", box);
        jPanel2.add("Center", box2);
        jPanel2.add("South", box3);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("Center", box4);
        jPanel.setLayout(new GridLayout(1, 2, 8, 8));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.setLayout(new BorderLayout());
        this.add("North", jPanel);
    }

    private Box createBox(String string, List list, RDFSDatatype[] rDFSDatatypeArray) {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder(string));
        for (int i = 0; i < rDFSDatatypeArray.length; ++i) {
            RDFSDatatype rDFSDatatype = rDFSDatatypeArray[i];
            list.remove(rDFSDatatype);
            box.add(new DatatypeCheckBox(rDFSDatatype));
        }
        return box;
    }

    public boolean getRequiresReloadUI() {
        return false;
    }

    private class DatatypeCheckBox
    extends JCheckBox {
        private RDFSDatatype datatype;

        DatatypeCheckBox(RDFSDatatype rDFSDatatype) {
            super(rDFSDatatype.getBrowserText());
            this.datatype = rDFSDatatype;
            this.setSelected(rDFSDatatype.isVisible());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DatatypeCheckBox.this.handleChanged();
                }
            });
        }

        private void handleChanged() {
            this.datatype.setVisible(this.isSelected());
            DatatypeSettingsPanel.this.changed = true;
        }
    }
}

