/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class AnnotationsViewSettingsPanel
extends JPanel {
    private SelectableList list;
    private OWLModel owlModel;

    public AnnotationsViewSettingsPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.list = new SelectableList();
        this.list.setListData(((AbstractOWLModel)oWLModel).getDefaultAnnotationPropertiesInView().toArray());
        this.list.setCellRenderer((ListCellRenderer)((Object)new ResourceRenderer()));
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Default annotation properties to be shown in the Annotation Widget", new JScrollPane((Component)this.list));
        oWLLabeledComponent.addHeaderButton(new AbstractAction("Add property...", OWLIcons.getAddIcon("RDFProperty")){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationsViewSettingsPanel.this.addProperty();
            }
        });
        oWLLabeledComponent.addHeaderButton((Action)new AllowableAction("Remove selected property", OWLIcons.getRemoveIcon("RDFProperty"), (Selectable)this.list){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationsViewSettingsPanel.this.removeSelectedProperty();
            }
        });
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    private void addProperty() {
        Collection collection = ((AbstractOWLModel)this.owlModel).getDefaultAnnotationPropertiesInView();
        Collection collection2 = this.owlModel.getRDFProperties();
        Object object = collection2.iterator();
        while (object.hasNext()) {
            RDFProperty rDFProperty = (RDFProperty)object.next();
            if (!collection.contains(rDFProperty) && (rDFProperty.getValueType() == ValueType.STRING || rDFProperty.isAnnotationProperty())) continue;
            object.remove();
        }
        object = new HashSet(collection);
        object.addAll(ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection(this, this.owlModel, collection2, "Add properties..."));
        ((AbstractOWLModel)this.owlModel).setDefaultAnnotationPropertiesInView((Collection)object);
        this.list.setListData(((AbstractOWLModel)this.owlModel).getDefaultAnnotationPropertiesInView().toArray());
    }

    private void removeSelectedProperty() {
        Collection collection = ((AbstractOWLModel)this.owlModel).getDefaultAnnotationPropertiesInView();
        collection.removeAll(this.list.getSelection());
        ((AbstractOWLModel)this.owlModel).setDefaultAnnotationPropertiesInView(collection);
        this.list.setListData(((AbstractOWLModel)this.owlModel).getDefaultAnnotationPropertiesInView().toArray());
    }
}

