/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.code;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.OntModelProvider;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.jena.JenaSchemagenAction;
import edu.stanford.smi.protegex.owl.ui.menu.code.KazukiPanel;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.daml.kazuki.ClassCatalog;
import org.daml.kazuki.Datatypes;
import org.daml.kazuki.GenerateInterface;
import org.daml.kazuki.VocabularyCatalog;

public class KazukiAction
extends AbstractOWLModelAction {
    private static final transient Logger log = Log.getLogger(KazukiAction.class);
    public static final String SCHEMA = "Schema";
    public static final String KAZUKI_JAVAC = "KAZUKI-JAVAC";
    public static final String KAZUKI_ROOT_FOLDER = "KAZUKI-ROOT-FOLDER";
    public static final String KAZUKI_PACKAGE = "KAZUKI-PACKAGE";

    public String getMenubarPath() {
        return "Code/1_Java_Code";
    }

    public String getName() {
        return "Generate Kazuki Java classes...";
    }

    public void run(OWLModel oWLModel) {
        OWLProject oWLProject = oWLModel.getOWLProject();
        OntModelProvider ontModelProvider = (OntModelProvider)((Object)oWLModel);
        KazukiPanel kazukiPanel = new KazukiPanel();
        kazukiPanel.setRootFolder(oWLProject.getSettingsMap().getString(KAZUKI_ROOT_FOLDER));
        kazukiPanel.setPackage(oWLProject.getSettingsMap().getString(KAZUKI_PACKAGE));
        String string = oWLProject.getSettingsMap().getString(KAZUKI_JAVAC);
        if (string == null || string.length() == 0) {
            string = "javac";
        }
        kazukiPanel.setJavaC(string);
        Component component = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
        if (ProtegeUI.getModalDialogFactory().showDialog(component, kazukiPanel, this.getName(), 11) == 1) {
            oWLProject.getSettingsMap().setString(KAZUKI_PACKAGE, kazukiPanel.getPackage());
            oWLProject.getSettingsMap().setString(KAZUKI_ROOT_FOLDER, kazukiPanel.getRootFolder());
            oWLProject.getSettingsMap().setString(KAZUKI_JAVAC, kazukiPanel.getJavaC());
            File file = new File(kazukiPanel.getRootFolder());
            for (int i = 0; i < 2; ++i) {
                try {
                    KazukiAction.generate(ontModelProvider, file, kazukiPanel.getPackage(), kazukiPanel.getJavaC(), kazukiPanel.isOverwriteMode());
                    ProtegeUI.getModalDialogFactory().showMessageDialog(component, "Schema generated to " + file + ".");
                    return;
                }
                catch (Exception exception) {
                    if (i <= 0) continue;
                    Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(component, "Error: " + exception);
                    continue;
                }
            }
        }
    }

    public static void generate(OntModelProvider ontModelProvider, File file, String string, String string2, boolean bl) throws Exception {
        Object object;
        OntModel ontModel = ontModelProvider.getOntModel();
        File file2 = file;
        if (string != null && string.length() > 0) {
            object = string.replace('.', '/');
            file2 = new File(file, (String)object);
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        object = new File(file, "Schema.java");
        log.info("Generating schema " + object);
        JenaSchemagenAction.generate(ontModelProvider, (File)object, null);
        log.info("Compiling schema");
        Runtime.getRuntime().exec(string2 + " -classpath plugins/edu.stanford.smi.protegex.owl/jena.jar " + ((File)object).toString());
        System.gc();
        GenerateInterface generateInterface = new GenerateInterface();
        generateInterface.OPT_ROOT_DIR = file2.getAbsolutePath();
        generateInterface.OPT_ROOT_PACKAGE = string;
        generateInterface.OPT_CUSTOM_P = true;
        generateInterface.OPT_GENERATE_VOCABULARY = false;
        generateInterface.OPT_VOCAB_DIR = file.getAbsolutePath();
        generateInterface.OPT_VOCAB_PACKAGE = "";
        generateInterface.OPT_VOCAB_BIN = "";
        generateInterface.OPT_LOAD_IMPORTS = false;
        generateInterface.OPT_DATE_P = true;
        generateInterface.OPT_OVERWRITE_P = bl;
        OntModel ontModel2 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)ontModel);
        Class<?> clazz = Class.forName("com.hp.hpl.jena.rdf.model.Resource");
        ClassLoader classLoader = clazz.getClassLoader();
        VocabularyClassLoader vocabularyClassLoader = new VocabularyClassLoader(classLoader, file.toString());
        VocabularyCatalog vocabularyCatalog = new VocabularyCatalog((ClassLoader)vocabularyClassLoader);
        vocabularyCatalog.parseVocabulary(SCHEMA);
        generateInterface.generateInterface(ontModel2, vocabularyCatalog, new ClassCatalog(), new Datatypes());
        ((File)object).delete();
        JenaSchemagenAction.generate(ontModelProvider, new File(file2, "base/Schema.java"), string + ".base");
        JenaSchemagenAction.generate(ontModelProvider, new File(file2, "custom/Schema.java"), string + ".custom");
    }

    public static class VocabularyClassLoader
    extends ClassLoader {
        String _sRoot;

        public VocabularyClassLoader(String string) {
            super(Thread.currentThread().getContextClassLoader());
            this._sRoot = string;
        }

        public VocabularyClassLoader(ClassLoader classLoader, String string) {
            super(classLoader);
            this._sRoot = string;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            StringBuffer stringBuffer = new StringBuffer(this._sRoot);
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("/" + stringTokenizer.nextToken());
            }
            stringBuffer.append(".class");
            File file = new File(stringBuffer.toString());
            if (!file.exists()) {
                throw new ClassNotFoundException(file.toString());
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[(int)file.length()];
                fileInputStream.read(byArray);
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ClassNotFoundException();
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException();
            }
        }
    }
}

