/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.tidy.Checker;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.OntModelProvider;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;

public class ValidatorAction
extends AbstractOWLModelAction {
    public String getMenubarPath() {
        return "Tools";
    }

    public String getName() {
        return "Determine OWL Sublanguage...";
    }

    public void run(OWLModel oWLModel) {
        Object object;
        Set<String> set = oWLModel.getAllImports();
        HashMap<URI, String> hashMap = new HashMap<URI, String>();
        for (String object2 : set) {
            try {
                URI uRISyntaxException = new URI(object2);
                object = oWLModel.getRepositoryManager().getRepository(uRISyntaxException);
                if (object == null) continue;
                hashMap.put(uRISyntaxException, object.getOntologyLocationDescription(uRISyntaxException));
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
            }
        }
        if (!hashMap.isEmpty()) {
            Object object3 = "Your project uses redirected imports.  The species validation does not use these imports\nand therefore the following result may be wrong.  The following\nURI aliases are used:\n";
            for (URI uRISyntaxException : hashMap.keySet()) {
                object = (String)hashMap.get(uRISyntaxException);
                object3 = (String)object3 + "- " + uRISyntaxException + "\n   has alias " + (String)object + "\n";
            }
            ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, (String)object3, "Warning");
        }
        if (!OWLUI.isConfirmationNeeded(oWLModel) || OWLUI.isConfirmed(oWLModel, oWLModel.getRDFResourceCount() > OWLUI.getConfirmationThreshold(oWLModel))) {
            this.performAction(oWLModel);
        }
    }

    private void performAction(OWLModel oWLModel) {
        OntModelProvider ontModelProvider = (OntModelProvider)((Object)oWLModel);
        String string = Jena.getOWLSpeciesString(ontModelProvider.getOWLSpecies());
        ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "The OWL sublanguage of this ontology is OWL " + string, "OWL Sublanguage");
    }

    public static String getSubLanguage(OntModel ontModel) {
        Checker checker = new Checker(false);
        checker.addGraphAndImports(ontModel.getGraph());
        String string = checker.getSubLanguage();
        return string;
    }
}

