/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu;

import edu.stanford.smi.protege.action.ArchiveProject;
import edu.stanford.smi.protege.action.Copy;
import edu.stanford.smi.protege.action.CreateProject;
import edu.stanford.smi.protege.action.Cut;
import edu.stanford.smi.protege.action.DisplayHtml;
import edu.stanford.smi.protege.action.OpenProject;
import edu.stanford.smi.protege.action.Paste;
import edu.stanford.smi.protege.action.RedoAction;
import edu.stanford.smi.protege.action.RevertProject;
import edu.stanford.smi.protege.action.SaveProject;
import edu.stanford.smi.protege.action.ShowAboutPluginsBox;
import edu.stanford.smi.protege.action.UndoAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.ProjectPluginAdapter;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ProjectMenuBar;
import edu.stanford.smi.protege.ui.ProjectToolBar;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerPluginMenuManager;
import edu.stanford.smi.protegex.owl.javacode.JavaCodeGeneratorResourceAction;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.model.util.XSDVisibility;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.OWLModelAction;
import edu.stanford.smi.protegex.owl.ui.actions.OWLModelActionManager;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.actions.ShowAboutProtegeOWLAction;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsGenerator;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsLoader;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.menu.OWLModelActionAction;
import edu.stanford.smi.protegex.owl.ui.menu.SyntaxHelpAction;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryManager;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassesPanel;
import edu.stanford.smi.protegex.owl.ui.tooltips.ClassDescriptionToolTipGenerator;
import edu.stanford.smi.protegex.owl.ui.tooltips.HomeOntologyToolTipGenerator;
import edu.stanford.smi.protegex.owl.ui.widget.OWLToolTipGenerator;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class OWLMenuProjectPlugin
extends ProjectPluginAdapter {
    private static final String CHANGED_WIDGETS = "ChangedWidgets";
    private static final String HELP_URL_GETTING_STARTED = "http://protege.stanford.edu/doc/owl/getting-started.html";
    private static final String HELP_URL_FAQ = "http://protege.stanford.edu/doc/owl-faq.html";
    private static final String HELP_URL_OWL_TUTORIAL = "http://www.co-ode.org/resources/tutorials/protege-owl-tutorial.php";
    public static final String PROSE_PROPERTY = "OWL-Prose";
    public static final String MENU_NAME = "OWL";
    private SyntaxHelpAction syntaxHelpAction = new SyntaxHelpAction();
    private JCheckBoxMenuItem proseBox;
    private OWLModelAction recentAction = null;

    private void addToolBarButton(JToolBar jToolBar, Action action) {
        ComponentFactory.addToolBarButton((JToolBar)jToolBar, (Action)action);
    }

    private void addToolBarButton(JToolBar jToolBar, Action action, Icon icon) {
        action.putValue("SmallIcon", icon);
        action.putValue("DisabledSmallIcon", null);
        this.addToolBarButton(jToolBar, action);
    }

    private void adjustMenuAndToolBar(final OWLModel oWLModel, final ProjectMenuBar projectMenuBar, final ProjectToolBar projectToolBar) {
        JMenu jMenu = new JMenu(MENU_NAME);
        jMenu.setMnemonic(79);
        JMenu jMenu2 = new JMenu("Reasoning");
        jMenu2.setMnemonic(82);
        JMenu jMenu3 = ComponentUtilities.getMenu((JMenuBar)projectMenuBar, (String)"Code", (boolean)true, (int)(projectMenuBar.getComponentCount() - 2));
        jMenu3.setMnemonic(67);
        JMenu jMenu4 = new JMenu("Tools");
        jMenu4.setMnemonic(84);
        JMenu jMenu5 = ComponentUtilities.getMenu((JMenuBar)projectMenuBar, (String)LocalizedText.getText((ResourceKey)ResourceKey.MENUBAR_HELP));
        if (jMenu5 != null) {
            this.regenerateHelpMenu(jMenu5, oWLModel);
        } else {
            Log.getLogger().warning("Protege-OWL could not adapt the Help menu.");
        }
        projectMenuBar.add((Component)jMenu, 3);
        projectMenuBar.add((Component)jMenu2, 4);
        projectMenuBar.add((Component)jMenu3, 5);
        projectMenuBar.add((Component)jMenu4, 6);
        ReasonerPluginMenuManager.fillReasoningMenu(oWLModel, jMenu2);
        this.disableProjectMenuItem(projectMenuBar, ResourceKey.PROJECT_MANAGE_INCLUDED);
        this.disableProjectMenuItem(projectMenuBar, ResourceKey.PROJECT_CHANGE_INCLUDED);
        this.disableProjectMenuItem(projectMenuBar, ResourceKey.PROJECT_MERGE_INCLUDED);
        this.disableProjectMenuItem(projectMenuBar, ResourceKey.PROJECT_SHOW_INCLUDED);
        this.disableProjectMenuItem(projectMenuBar, ResourceKey.PROJECT_INCLUDE);
        this.disableMenuItem(projectMenuBar, ResourceKey.MENUBAR_PROJECT, ResourceKey.PROJECT_METRICS, false);
        this.adjustToolBar((JToolBar)projectToolBar);
        this.recentAction = null;
        OWLModelActionManager.addOWLModelActionsToMenubar(oWLModel, new OWLModelActionManager.Adder(){

            public void addOWLModelAction(OWLModelAction oWLModelAction) {
                OWLMenuProjectPlugin.this.addOWLModelActionToMenuBar(oWLModelAction, oWLModel, projectMenuBar);
            }
        });
        this.recentAction = null;
        OWLModelActionManager.addOWLModelActionsToToolbar(oWLModel, new OWLModelActionManager.Adder(){

            public void addOWLModelAction(OWLModelAction oWLModelAction) {
                OWLMenuProjectPlugin.this.addOWLModelActionToToolBar(oWLModelAction, oWLModel, projectToolBar);
            }
        });
        projectToolBar.addSeparator();
        NavigationHistoryManager navigationHistoryManager = ProtegeUI.getNavigationHistoryManager(oWLModel);
        navigationHistoryManager.add(oWLModel.getOWLThingClass());
        projectToolBar.add((Action)navigationHistoryManager.getBackAction());
        projectToolBar.add((Action)navigationHistoryManager.getForwardAction());
        for (int i = 0; i < projectMenuBar.getMenuCount(); ++i) {
            JMenuItem jMenuItem;
            JMenu jMenu6 = projectMenuBar.getMenu(i);
            if (jMenu6.getItemCount() <= 0 || (jMenuItem = jMenu6.getItem(0)) != null) continue;
            jMenu6.remove(0);
        }
    }

    private void addOWLModelActionToMenuBar(OWLModelAction oWLModelAction, OWLModel oWLModel, ProjectMenuBar projectMenuBar) {
        Action action;
        StringTokenizer stringTokenizer = new StringTokenizer(oWLModelAction.getMenubarPath(), "/", false);
        if (stringTokenizer.hasMoreElements() && (action = this.createAction(oWLModelAction, oWLModel)) != null) {
            String string = stringTokenizer.nextToken();
            JMenu jMenu = null;
            for (int i = 0; i < projectMenuBar.getMenuCount(); ++i) {
                if (!string.equals(projectMenuBar.getMenu(i).getText())) continue;
                jMenu = projectMenuBar.getMenu(i);
            }
            if (jMenu == null) {
                jMenu = new JMenu(string);
                projectMenuBar.add((Component)jMenu, projectMenuBar.getMenuCount() - 1);
            } else if (this.recentAction != null && !this.recentAction.getMenubarPath().equals(oWLModelAction.getMenubarPath())) {
                jMenu.addSeparator();
            }
            jMenu.add(action);
        }
        this.recentAction = oWLModelAction;
    }

    private void addOWLModelActionToToolBar(OWLModelAction oWLModelAction, OWLModel oWLModel, ProjectToolBar projectToolBar) {
        Action action = this.createAction(oWLModelAction, oWLModel);
        if (action != null) {
            if (this.recentAction != null && !this.recentAction.getToolbarPath().equals(oWLModelAction.getToolbarPath())) {
                projectToolBar.addSeparator();
            }
            this.addToolBarButton((JToolBar)projectToolBar, action);
        }
        this.recentAction = oWLModelAction;
    }

    private void adjustToolBar(JToolBar jToolBar) {
        jToolBar.removeAll();
        this.addToolBarButton(jToolBar, (Action)new CreateProject(true), OWLIcons.getImageIcon("File"));
        this.addToolBarButton(jToolBar, (Action)new OpenProject(true), OWLIcons.getOpenProjectIcon());
        this.addToolBarButton(jToolBar, (Action)new SaveProject(true), OWLIcons.getSaveProjectIcon());
        jToolBar.addSeparator();
        this.addToolBarButton(jToolBar, (Action)new Cut(true), OWLIcons.getCutIcon());
        this.addToolBarButton(jToolBar, (Action)new Copy(true), OWLIcons.getCopyIcon());
        this.addToolBarButton(jToolBar, (Action)new Paste(true), OWLIcons.getPasteIcon());
        jToolBar.addSeparator();
        this.addToolBarButton(jToolBar, (Action)new ArchiveProject(true), OWLIcons.getArchiveProjectIcon());
        this.addToolBarButton(jToolBar, (Action)new RevertProject(true), OWLIcons.getRevertProjectIcon());
        jToolBar.addSeparator();
        this.addToolBarButton(jToolBar, (Action)new UndoAction(true), OWLIcons.getUndoIcon());
        this.addToolBarButton(jToolBar, (Action)new RedoAction(true), OWLIcons.getRedoIcon());
        jToolBar.addSeparator();
    }

    public void afterCreate(Project project) {
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        if (knowledgeBase instanceof OWLModel) {
            OWLUI.fixBrowserSlotPatterns(project);
            OWLModel oWLModel = (OWLModel)knowledgeBase;
            if (oWLModel instanceof OWLDatabaseModel) {
                ((OWLDatabaseModel)project.getKnowledgeBase()).initDefaultNamespaces();
            }
        }
    }

    public void afterLoad(Project project) {
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        if (!(knowledgeBase instanceof OWLModel)) {
            return;
        }
        OWLModel oWLModel = (OWLModel)knowledgeBase;
        oWLModel.getOWLThingClass().setVisible(true);
        OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(oWLModel);
        project.setWidgetMapper((WidgetMapper)new OWLWidgetMapper(oWLModel));
        OWLUI.fixBrowserSlotPatterns(project);
        this.fix(oWLModel);
        if (project.getSources().getString(AbsoluteFormsGenerator.SAVE_FORMS_KEY) != null) {
            try {
                AbsoluteFormsLoader absoluteFormsLoader = new AbsoluteFormsLoader(oWLModel);
                absoluteFormsLoader.loadAll();
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught at loading absolute forms", exception);
            }
        }
    }

    public void afterSave(Project project) {
        if (project.getKnowledgeBase() instanceof OWLModel) {
            OWLModel oWLModel = (OWLModel)project.getKnowledgeBase();
            OWLMenuProjectPlugin.restoreWidgetsAfterSave(oWLModel);
        }
    }

    public void afterShow(ProjectView projectView, ProjectToolBar projectToolBar, ProjectMenuBar projectMenuBar) {
        KnowledgeBase knowledgeBase = projectView.getProject().getKnowledgeBase();
        if (knowledgeBase instanceof OWLModel) {
            OWLModel oWLModel = (OWLModel)knowledgeBase;
            ProtegeUI.register(projectView);
            if (oWLModel instanceof JenaOWLModel) {
                JenaOWLModel.inUI = true;
            }
            oWLModel.getProject().setInstanceDisplayClass(ResourceDisplay.class);
            this.adjustMenuAndToolBar(oWLModel, projectMenuBar, projectToolBar);
            this.adjustOWLAnnotationPropertyForm(projectView.getProject());
            ResourceActionManager.addResourceActionClass(JavaCodeGeneratorResourceAction.class);
        }
    }

    private void adjustOWLAnnotationPropertyForm(Project project) {
        OWLModel oWLModel = (OWLModel)project.getKnowledgeBase();
        try {
            ClsWidget clsWidget = project.getDesignTimeClsWidget((Cls)oWLModel.getOWLAnnotationPropertyClass());
            RDFProperty rDFProperty = oWLModel.getRDFSDomainProperty();
            clsWidget.replaceWidget((Slot)rDFProperty, null);
            RDFProperty rDFProperty2 = oWLModel.getRDFSRangeProperty();
            clsWidget.replaceWidget((Slot)rDFProperty2, null);
            Slot slot = oWLModel.getSystemFrames().getDirectDomainSlot();
            clsWidget.replaceWidget(slot, null);
            ((FormWidget)clsWidget).setVerticalStretcher("<<none>>");
            ((FormWidget)clsWidget).setHorizontalStretcher("<<all>>");
        }
        catch (Exception exception) {
            Log.getLogger().warning("Problems at adjusting the class form of owl:AnnotationProperty.");
        }
    }

    public void beforeHide(ProjectView projectView, ProjectToolBar projectToolBar, ProjectMenuBar projectMenuBar) {
        KnowledgeBase knowledgeBase = projectView.getProject().getKnowledgeBase();
        if (knowledgeBase instanceof OWLModel) {
            ProtegeUI.unregister(projectView);
            ChangedClassesPanel.dispose((OWLModel)knowledgeBase);
            OWLUI.setOWLToolTipGenerator(null);
            this.proseBox = null;
        }
    }

    public void beforeSave(Project project) {
        OWLModel oWLModel;
        String string;
        if (project.getKnowledgeBase() instanceof OWLModel && (string = (oWLModel = (OWLModel)project.getKnowledgeBase()).getOWLProject().getSettingsMap().getString(AbsoluteFormsGenerator.SAVE_FORMS_KEY)) != null) {
            AbsoluteFormsGenerator absoluteFormsGenerator = new AbsoluteFormsGenerator(oWLModel);
            try {
                absoluteFormsGenerator.generateFiles(string);
            }
            catch (Exception exception) {
                Log.getLogger().warning("Could not save .forms files");
                Log.getLogger().log(Level.WARNING, "Exception caught", exception);
            }
            if (AbsoluteFormsLoader.useNewFormMechanism_DontUseThisMethod()) {
                OWLMenuProjectPlugin.prepareWidgetsForSave(oWLModel);
            }
        }
    }

    private Action createAction(OWLModelAction oWLModelAction, OWLModel oWLModel) {
        return new OWLModelActionAction(oWLModelAction, oWLModel);
    }

    private void disableProjectMenuItem(ProjectMenuBar projectMenuBar, ResourceKey resourceKey) {
        this.disableMenuItem(projectMenuBar, ResourceKey.MENUBAR_PROJECT, resourceKey, true);
    }

    private void disableMenuItem(ProjectMenuBar projectMenuBar, ResourceKey resourceKey, ResourceKey resourceKey2, boolean bl) {
        String string = LocalizedText.getText((ResourceKey)resourceKey);
        String string2 = LocalizedText.getText((ResourceKey)resourceKey2);
        JMenu jMenu = projectMenuBar.getMenu(0);
        int n = 1;
        while (!jMenu.getText().equals(string)) {
            jMenu = projectMenuBar.getMenu(n);
            ++n;
        }
        for (n = 0; n < jMenu.getItemCount(); ++n) {
            JMenuItem jMenuItem = jMenu.getItem(n);
            if (jMenuItem == null || !string2.equals(jMenuItem.getText())) continue;
            jMenu.remove(jMenuItem);
            if (!bl || jMenu.getItem(n) != null) continue;
            jMenu.remove(n);
        }
    }

    private void fix(OWLModel oWLModel) {
        if (!oWLModel.getProject().isMultiUserClient()) {
            XSDVisibility.updateVisibility(oWLModel);
        }
    }

    public boolean isProseActivated() {
        return this.proseBox != null && this.proseBox.isSelected();
    }

    private static boolean isUsedInRange(Cls cls, Set set) {
        OWLModel oWLModel = (OWLModel)cls.getKnowledgeBase();
        if (oWLModel instanceof JenaOWLModel) {
            Collection collection = oWLModel.getReferences(cls, 1000);
            Slot slot = oWLModel.getSlot(":SLOT-VALUE-TYPE");
            for (Reference reference : collection) {
                Frame frame = reference.getFrame();
                if (!reference.getSlot().equals(slot) || set.contains(frame) || frame.getName().startsWith(ProtegeNames.PROTEGE_OWL_NAMESPACE)) continue;
                return true;
            }
        }
        return false;
    }

    public static void makeHiddenClsesWithSubclassesVisible(OWLModel oWLModel) {
        if (oWLModel.getOWLNamedClassClass().getSubclassCount() > 0 || oWLModel.getRDFSNamedClassClass().getSubclassCount() > 3) {
            oWLModel.getRDFSNamedClassClass().setVisible(true);
            oWLModel.getOWLNamedClassClass().setVisible(true);
        }
        HashSet hashSet = new HashSet(oWLModel.getOWLSystemResources());
        if (oWLModel.getOWLObjectPropertyClass().getSubclassCount() > 3 || oWLModel.getOWLDatatypePropertyClass().getSubclassCount() > 0 || OWLMenuProjectPlugin.isUsedInRange(oWLModel.getOWLObjectPropertyClass(), hashSet) || OWLMenuProjectPlugin.isUsedInRange(oWLModel.getOWLDatatypePropertyClass(), hashSet) || OWLMenuProjectPlugin.isUsedInRange(oWLModel.getRDFPropertyClass(), hashSet)) {
            oWLModel.getRDFPropertyClass().setVisible(true);
            oWLModel.getOWLObjectPropertyClass().setVisible(true);
            oWLModel.getOWLDatatypePropertyClass().setVisible(true);
        }
        OWLMenuProjectPlugin.makeVisibleIfSubclassesExist(oWLModel.getRDFListClass(), hashSet);
        OWLMenuProjectPlugin.makeVisibleIfSubclassesExist(oWLModel.getOWLDataRangeClass(), hashSet);
        OWLMenuProjectPlugin.makeVisibleIfSubclassesExist(oWLModel.getOWLNothing(), hashSet);
        OWLMenuProjectPlugin.makeVisibleIfSubclassesExist(oWLModel.getRDFSNamedClass(RDFNames.Cls.STATEMENT), hashSet);
        if (oWLModel.getDirectInstanceCount(oWLModel.getRDFUntypedResourcesClass()) > 0) {
            oWLModel.getRDFUntypedResourcesClass().setVisible(true);
        }
    }

    private static void makeVisibleIfSubclassesExist(Cls cls, Set set) {
        if (cls.getVisibleDirectSubclassCount() > 0 || OWLMenuProjectPlugin.isUsedInRange(cls, set)) {
            cls.setVisible(true);
        }
    }

    public static void prepareWidgetsForSave(OWLModel oWLModel) {
        Project project = oWLModel.getProject();
        ArrayList<WidgetDescriptor> arrayList = new ArrayList<WidgetDescriptor>();
        for (Cls cls : project.getClsesWithCustomizedForms()) {
            WidgetDescriptor widgetDescriptor;
            if (cls.isSystem() || (widgetDescriptor = project.getDesignTimeClsWidget(cls).getDescriptor()).isIncluded()) continue;
            arrayList.add(widgetDescriptor);
            widgetDescriptor.setIncluded(true);
        }
        oWLModel.getOWLProject().setSessionObject(CHANGED_WIDGETS, arrayList);
    }

    public static void restoreWidgetsAfterSave(OWLModel oWLModel) {
        OWLProject oWLProject = oWLModel.getOWLProject();
        Object object = oWLProject.getSessionObject(CHANGED_WIDGETS);
        if (object instanceof Collection) {
            for (WidgetDescriptor widgetDescriptor : (Collection)object) {
                widgetDescriptor.setIncluded(false);
            }
            oWLProject.setSessionObject(CHANGED_WIDGETS, null);
        }
    }

    private void regenerateHelpMenu(JMenu jMenu, final OWLModel oWLModel) {
        jMenu.removeAll();
        ComponentFactory.addMenuItemNoIcon((JMenu)jMenu, (Action)new DisplayHtml(ResourceKey.HELP_MENU_GETTING_STARTED, HELP_URL_GETTING_STARTED));
        ComponentFactory.addMenuItemNoIcon((JMenu)jMenu, (Action)new DisplayHtml(ResourceKey.HELP_MENU_FAQ, HELP_URL_FAQ));
        ComponentFactory.addMenuItemNoIcon((JMenu)jMenu, (Action)new AbstractAction("Prot\u00e9g\u00e9-OWL Tutorial..."){

            public void actionPerformed(ActionEvent actionEvent) {
                SystemUtilities.showHTML((String)OWLMenuProjectPlugin.HELP_URL_OWL_TUTORIAL);
            }
        });
        jMenu.addSeparator();
        ComponentFactory.addMenuItemNoIcon((JMenu)jMenu, (Action)this.syntaxHelpAction);
        this.proseBox = new JCheckBoxMenuItem("Display prose as tool tip of OWL expressions", true);
        jMenu.add(this.proseBox);
        this.proseBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                oWLModel.getOWLProject().getSettingsMap().setBoolean(OWLMenuProjectPlugin.PROSE_PROPERTY, OWLMenuProjectPlugin.this.proseBox.isSelected());
                if (OWLMenuProjectPlugin.this.proseBox.isSelected()) {
                    OWLUI.setOWLToolTipGenerator(new ClassDescriptionToolTipGenerator());
                } else {
                    OWLUI.setOWLToolTipGenerator(new HomeOntologyToolTipGenerator());
                }
            }
        });
        this.proseBox.setSelected(Boolean.TRUE.equals(oWLModel.getOWLProject().getSettingsMap().getBoolean(PROSE_PROPERTY)));
        OWLToolTipGenerator oWLToolTipGenerator = OWLUI.getOWLToolTipGenerator();
        if (oWLToolTipGenerator == null || oWLToolTipGenerator instanceof ClassDescriptionToolTipGenerator || oWLToolTipGenerator instanceof HomeOntologyToolTipGenerator) {
            OWLUI.setOWLToolTipGenerator(this.proseBox.isSelected() ? new ClassDescriptionToolTipGenerator() : new HomeOntologyToolTipGenerator());
        }
        jMenu.addSeparator();
        ComponentFactory.addMenuItemNoIcon((JMenu)jMenu, (Action)((Object)new ShowAboutProtegeOWLAction()));
        ComponentFactory.addMenuItemNoIcon((JMenu)jMenu, (Action)new ShowAboutPluginsBox());
        ComponentFactory.addMenuItemNoIcon((JMenu)jMenu, (Action)new DisplayHtml(ResourceKey.HELP_MENU_CITE_PROTEGE, ApplicationProperties.getHowToCiteProtegeURLString()));
    }
}

