/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.plugin.ProjectFixupPlugin;
import edu.stanford.smi.protege.resource.Files;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.CheckBoxWidget;
import edu.stanford.smi.protege.widget.ComboBoxWidget;
import edu.stanford.smi.protege.widget.FloatFieldWidget;
import edu.stanford.smi.protege.widget.FloatListWidget;
import edu.stanford.smi.protege.widget.IntegerFieldWidget;
import edu.stanford.smi.protege.widget.IntegerListWidget;
import edu.stanford.smi.protege.widget.StringListWidget;
import edu.stanford.smi.protege.widget.SymbolListWidget;
import edu.stanford.smi.protege.widget.TextAreaWidget;
import edu.stanford.smi.protege.widget.TextFieldWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.resource.OWLText;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.individuals.OWLIndividualsTab;
import edu.stanford.smi.protegex.owl.ui.widget.MultiLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.MultiResourceWidget;
import edu.stanford.smi.protegex.owl.ui.widget.RDFListWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleLiteralAreaWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleResourceWidget;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OWLBackwardsCompatibilityProjectFixups
implements ProjectFixupPlugin {
    public static final String OWL_BUILD_PROPERTY = "owl_build";
    public static final String OWL_MAJOR_BUILD_PROPERTY = "owl_major_build";
    public static final String OWL_DATABASE_INCLUSION = "parser_namespace_database_inclusion_version";
    private static final String SLOT_HIDDEN_FRAMES = "hidden_classes";
    private static final String CLASS_PROJECT = "Project";
    private static final String SLOT_SOURCES = "sources";

    public static void insertVersionData(PropertyList propertyList) {
        propertyList.setString(OWL_BUILD_PROPERTY, OWLText.getBuildNumber());
        propertyList.setString(OWL_MAJOR_BUILD_PROPERTY, OWLText.getVersion());
        propertyList.setBoolean(OWL_DATABASE_INCLUSION, true);
    }

    public static void fix(OWLModel oWLModel) {
        Project project = oWLModel.getProject();
        KnowledgeBase knowledgeBase = project.getInternalProjectKnowledgeBase();
        OWLBackwardsCompatibilityProjectFixups.fixInternalProject(knowledgeBase);
    }

    private static void fixInternalProject(KnowledgeBase knowledgeBase) {
        PropertyList propertyList = OWLBackwardsCompatibilityProjectFixups.getProjectSources(knowledgeBase);
        if (OWLBackwardsCompatibilityProjectFixups.isReallyAncientVersion(propertyList)) {
            Log.getLogger().info("Backwards compatibility fixup for OWL project file (really ancient one)");
            OWLBackwardsCompatibilityProjectFixups.fixReallyAncient(knowledgeBase);
        }
        if (OWLBackwardsCompatibilityProjectFixups.isBeforeDatabaseInclusion(propertyList)) {
            Log.getLogger().info("Backwards compatibility fixup for OWL project file (before DB inclusion)");
            OWLBackwardsCompatibilityProjectFixups.fixForDatabaseInclusion(knowledgeBase);
        }
    }

    public static boolean isBeforeDatabaseInclusion(PropertyList propertyList) {
        return propertyList.getBoolean(OWL_DATABASE_INCLUSION) == null;
    }

    private static void fixForDatabaseInclusion(KnowledgeBase knowledgeBase) {
        OWLBackwardsCompatibilityProjectFixups.adjustNamespacePrefix(knowledgeBase);
        OWLBackwardsCompatibilityProjectFixups.fixFramesVisibility(knowledgeBase);
    }

    private static void fixFramesVisibility(KnowledgeBase knowledgeBase) {
        Instance instance = OWLBackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase);
        OWLBackwardsCompatibilityProjectFixups.fixSWRLVisibility(knowledgeBase);
        ModelUtilities.removeOwnSlotValue((Frame)instance, (String)SLOT_HIDDEN_FRAMES, (Object)OWLNames.Cls.THING);
    }

    private static void fixSWRLVisibility(KnowledgeBase knowledgeBase) {
        SWRLSystemFrames sWRLSystemFrames = new SWRLSystemFrames(null);
        Collection collection = sWRLSystemFrames.getFrames();
        Instance instance = OWLBackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase);
        for (Frame frame : collection) {
            ModelUtilities.addOwnSlotValue((Frame)instance, (String)SLOT_HIDDEN_FRAMES, (Object)frame.getName());
        }
    }

    private static void adjustNamespacePrefix(KnowledgeBase knowledgeBase) {
        for (Instance instance : knowledgeBase.getInstances()) {
            for (Slot slot : instance.getOwnSlots()) {
                List list = instance.getDirectOwnSlotValues(slot);
                OWLBackwardsCompatibilityProjectFixups.adjustNamespacePrefix(instance, slot, list);
            }
        }
    }

    private static void adjustNamespacePrefix(Instance instance, Slot slot, Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (Object e : collection) {
            if (e instanceof String) {
                arrayList.add(OWLBackwardsCompatibilityProjectFixups.adjustNamespacePrefix((String)e));
                bl = true;
                continue;
            }
            arrayList.add((String)e);
        }
        if (bl) {
            instance.setDirectOwnSlotValues(slot, arrayList);
        }
    }

    private static String adjustNamespacePrefix(String string) {
        String string2 = "rdf:";
        if (string.startsWith(string2)) {
            return OWLBackwardsCompatibilityProjectFixups.replacePrefix(string, string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        }
        string2 = "rdfs:";
        if (string.startsWith(string2)) {
            return OWLBackwardsCompatibilityProjectFixups.replacePrefix(string, string2, "http://www.w3.org/2000/01/rdf-schema#");
        }
        string2 = "owl:";
        if (string.startsWith(string2)) {
            return OWLBackwardsCompatibilityProjectFixups.replacePrefix(string, string2, "http://www.w3.org/2002/07/owl#");
        }
        string2 = "swrl:";
        if (string.startsWith(string2)) {
            return OWLBackwardsCompatibilityProjectFixups.replacePrefix(string, string2, "http://www.w3.org/2003/11/swrl#");
        }
        string2 = ProtegeNames.PROTEGE_PREFIX + ":";
        if (string.startsWith(string2)) {
            return OWLBackwardsCompatibilityProjectFixups.replacePrefix(string, string2, ProtegeNames.PROTEGE_OWL_NAMESPACE);
        }
        return string;
    }

    private static String replacePrefix(String string, String string2, String string3) {
        return string3 + string.substring(string2.length());
    }

    public static boolean isReallyAncientVersion(PropertyList propertyList) {
        return propertyList.getString(OWL_BUILD_PROPERTY) == null;
    }

    private static void fixReallyAncient(KnowledgeBase knowledgeBase) {
        OWLBackwardsCompatibilityProjectFixups.updateStandardForms(knowledgeBase);
        OWLBackwardsCompatibilityProjectFixups.renameWidgets(knowledgeBase);
        OWLBackwardsCompatibilityProjectFixups.fixFramesVisibility(knowledgeBase);
    }

    private static void renameWidgets(KnowledgeBase knowledgeBase) {
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, "edu.stanford.smi.protegex.owl.ui.cls.OWLClsesTab", OWLClassesTab.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, "edu.stanford.smi.protegex.owl.ui.OWLIndividualsTab", OWLIndividualsTab.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, "edu.stanford.smi.protegex.owl.ui.widget.OWLInstanceListWidget", MultiResourceWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, "edu.stanford.smi.protegex.owl.ui.widget.OWLInstanceFieldWidget", SingleResourceWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, "edu.stanford.smi.protegex.owl.ui.widget.ListInstanceWidget", RDFListWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, "edu.stanford.smi.protegex.owl.ui.widget.LiteralFieldWidget", SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, "edu.stanford.smi.protegex.owl.ui.widget.LiteralListWidget", MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, "edu.stanford.smi.protegex.owl.ui.widget.MultiLanguageStringValueWidget", MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, TextFieldWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, TextAreaWidget.class.getName(), SingleLiteralAreaWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, CheckBoxWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, ComboBoxWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, FloatFieldWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, FloatListWidget.class.getName(), MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, IntegerFieldWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, IntegerListWidget.class.getName(), MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, StringListWidget.class.getName(), MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(knowledgeBase, SymbolListWidget.class.getName(), MultiLiteralWidget.class.getName());
    }

    private static void changeInstanceValue(KnowledgeBase knowledgeBase, String string, String string2, String string3, String string4, Object object, Object object2) {
        Cls cls = knowledgeBase.getCls(string);
        Slot slot = knowledgeBase.getSlot(string2);
        Slot slot2 = knowledgeBase.getSlot(string4);
        for (Instance instance : cls.getInstances()) {
            if (!string3.equals(instance.getOwnSlotValue(slot)) || !object.equals(instance.getOwnSlotValue(slot2))) continue;
            instance.setOwnSlotValue(slot2, object2);
        }
    }

    private static Instance getClsWidgetInstance(String string, KnowledgeBase knowledgeBase) {
        Instance instance = null;
        List list = ModelUtilities.getDirectOwnSlotValues((Frame)OWLBackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase), (String)"customized_instance_widgets");
        for (Instance instance2 : list) {
            String string2 = (String)ModelUtilities.getDirectOwnSlotValue((Frame)instance2, (String)"name");
            if (!string.equals(string2)) continue;
            instance = instance2;
            break;
        }
        return instance;
    }

    private static KnowledgeBaseFactory getFactory(KnowledgeBase knowledgeBase) {
        KnowledgeBaseFactory knowledgeBaseFactory = null;
        Instance instance = OWLBackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase);
        Instance instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue((Frame)instance, (String)SLOT_SOURCES);
        for (Instance instance3 : ModelUtilities.getDirectOwnSlotValues((Frame)instance2, (String)"properties")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue((Frame)instance3, (String)"name");
            if (!string.equals("factory_class_name")) continue;
            String string2 = (String)ModelUtilities.getDirectOwnSlotValue((Frame)instance3, (String)"string_value");
            knowledgeBaseFactory = (KnowledgeBaseFactory)SystemUtilities.newInstance((String)string2);
            break;
        }
        return knowledgeBaseFactory;
    }

    private static KnowledgeBase getTemplateKnowledgeBase(KnowledgeBase knowledgeBase) {
        ArrayList arrayList = new ArrayList();
        Reader reader = Files.getSystemClsesReader();
        KnowledgeBaseFactory knowledgeBaseFactory = OWLBackwardsCompatibilityProjectFixups.getFactory(knowledgeBase);
        String string = knowledgeBaseFactory == null ? (String)null : knowledgeBaseFactory.getProjectFilePath();
        Reader reader2 = string == null ? Files.getSystemInstancesReader() : FileUtilities.getResourceReader(knowledgeBaseFactory.getClass(), (String)string);
        return new ClipsKnowledgeBaseFactory().loadKnowledgeBase(reader, reader2, arrayList);
    }

    private static void renameWidget(KnowledgeBase knowledgeBase, String string, String string2) {
        OWLBackwardsCompatibilityProjectFixups.changeInstanceValue(knowledgeBase, "Widget", "widget_class_name", string, "widget_class_name", string, string2);
    }

    private static boolean replaceFormWidget(String string, KnowledgeBase knowledgeBase, KnowledgeBase knowledgeBase2) {
        Instance instance;
        Cls cls;
        Instance instance2 = OWLBackwardsCompatibilityProjectFixups.getClsWidgetInstance(string, knowledgeBase2);
        Instance instance3 = OWLBackwardsCompatibilityProjectFixups.getClsWidgetInstance(string, knowledgeBase);
        if (instance3 == null) {
            cls = knowledgeBase.getCls("Widget");
            instance3 = knowledgeBase.createInstance(null, cls);
            ModelUtilities.setOwnSlotValue((Frame)instance3, (String)"name", (Object)string);
            instance = OWLBackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase);
            ModelUtilities.addOwnSlotValue((Frame)instance, (String)"customized_instance_widgets", (Object)instance3);
        }
        cls = (Instance)ModelUtilities.getDirectOwnSlotValue((Frame)instance2, (String)"property_list");
        instance = (Instance)cls.deepCopy(knowledgeBase, null);
        ModelUtilities.setOwnSlotValue((Frame)instance3, (String)"property_list", (Object)instance);
        return instance2 != null;
    }

    private static void updateStandardForms(KnowledgeBase knowledgeBase) {
        KnowledgeBase knowledgeBase2 = OWLBackwardsCompatibilityProjectFixups.getTemplateKnowledgeBase(knowledgeBase);
        Instance instance = OWLBackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase2);
        for (Instance instance2 : ModelUtilities.getDirectOwnSlotValues((Frame)instance, (String)"customized_instance_widgets")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue((Frame)instance2, (String)"name");
            boolean bl = OWLBackwardsCompatibilityProjectFixups.replaceFormWidget(string, knowledgeBase, knowledgeBase2);
        }
    }

    public void fixProject(KnowledgeBase knowledgeBase) {
        OWLBackwardsCompatibilityProjectFixups.fixInternalProject(knowledgeBase);
    }

    public String getName() {
        return "OWL Backward Project Compatibility Fixups";
    }

    public void dispose() {
    }

    public static boolean isSuitable(KnowledgeBase knowledgeBase, Collection collection) {
        String string = OWLBackwardsCompatibilityProjectFixups.getProjectSources(knowledgeBase).getString("factory_class_name");
        return string != null && string.contains(".owl.");
    }

    protected static Instance getProjectInstance(KnowledgeBase knowledgeBase) {
        Instance instance = null;
        Cls cls = knowledgeBase.getCls(CLASS_PROJECT);
        if (cls == null) {
            Log.getLogger().severe("no project class");
        } else {
            Collection collection = cls.getDirectInstances();
            instance = (Instance)CollectionUtilities.getFirstItem((Collection)collection);
        }
        if (instance == null) {
            Log.getLogger().severe("no project instance");
        }
        return instance;
    }

    private static PropertyList getProjectSources(KnowledgeBase knowledgeBase) {
        Instance instance = OWLBackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase);
        return new PropertyList((Instance)ModelUtilities.getDirectOwnSlotValue((Frame)instance, (String)SLOT_SOURCES));
    }
}

