/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.matrix.EditableMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MatrixTable
extends JTable {
    private MatrixTableModel tableModel;

    public MatrixTable(MatrixTableModel matrixTableModel) {
        this.tableModel = matrixTableModel;
        this.tableModel.setTable(this);
        this.setModel(matrixTableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.getSelectionModel().setSelectionMode(0);
        this.setRowHeight(Math.max(this.getFontMetrics(this.getFont()).getHeight(), 16));
        this.initColumns();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MatrixTable.this.handleDoubleClick();
                }
            }
        });
        this.addMouseListener((MouseListener)new PopupMenuMouseListener(this){

            protected JPopupMenu getPopupMenu() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                int n = MatrixTable.this.getSelectedRow();
                if (n >= 0 && n < MatrixTable.this.tableModel.getRowCount()) {
                    ResourceActionManager.addResourceActions(jPopupMenu, (Component)MatrixTable.this, MatrixTable.this.tableModel.getInstance(n));
                }
                if (jPopupMenu.getComponentCount() > 0) {
                    return jPopupMenu;
                }
                return null;
            }

            protected void setSelection(JComponent jComponent, int n, int n2) {
                int n3 = n2 / MatrixTable.this.getRowHeight();
                if (n3 >= 0 && n3 < MatrixTable.this.tableModel.getRowCount()) {
                    MatrixTable.this.getSelectionModel().setSelectionInterval(n3, n3);
                }
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = tableColumnModel.getColumn(n).getModelIndex();
                if (MatrixTable.this.tableModel.isSortableColumn(n2)) {
                    MatrixTable.this.setSortColumn(n2);
                }
            }
        });
    }

    public void addColumn(MatrixColumn matrixColumn) {
        int n = this.tableModel.getNewColumnIndex(matrixColumn);
        this.tableModel.addColumn(matrixColumn, n);
        this.addColumn(new TableColumn(n));
        this.initColumns();
        this.getTableHeader().repaint();
    }

    public void close() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof ResultsPanel); container = container.getParent()) {
        }
        if (container != null) {
            ResultsPanel resultsPanel = (ResultsPanel)container;
            resultsPanel.close();
        }
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        MatrixColumn matrixColumn = this.tableModel.getMatrixColumn(n2);
        if (matrixColumn instanceof EditableMatrixColumn) {
            return ((EditableMatrixColumn)matrixColumn).getTableCellEditor();
        }
        return super.getCellEditor();
    }

    public void initColumns() {
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            MatrixColumn matrixColumn = this.tableModel.getMatrixColumn(i);
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setHeaderValue(matrixColumn.getName());
            tableColumn.setCellRenderer(matrixColumn.getCellRenderer());
            tableColumn.setPreferredWidth(matrixColumn.getWidth());
        }
    }

    private void handleDoubleClick() {
        int n = this.getSelectedRow();
        if (n >= 0 && n < this.tableModel.getRowCount()) {
            RDFResource rDFResource = this.tableModel.getInstance(n);
            ResultsPanelManager.showHostResource(rDFResource);
        }
    }

    private void setSortColumn(int n) {
        this.tableModel.setSortColumn(n);
        this.initColumns();
    }

    public RDFResource getSelectedInstance() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            return this.tableModel.getInstance(n);
        }
        return null;
    }
}

