/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.AnnotationPropertyMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTable;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JScrollPane;

public class MatrixPanel
extends ResultsPanel {
    private ResourceSelectionAction addAnnotationPropertyAction = new ResourceSelectionAction("Add column for annotation property...", OWLIcons.getAddIcon("AnnotationOWLDatatypeProperty")){

        public void resourceSelected(RDFResource rDFResource) {
            MatrixPanel.this.addAnnotationProperty((RDFProperty)rDFResource);
        }

        public RDFResource pickResource() {
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(MatrixPanel.this, MatrixPanel.this.getOWLModel(), this.getSelectableResources(), "Select annotation property");
        }

        public Collection getSelectableResources() {
            ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>(MatrixPanel.this.owlModel.getOWLAnnotationProperties());
            arrayList.removeAll(MatrixPanel.this.tableModel.getVisibleAnnotationProperties());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                RDFProperty rDFProperty = (RDFProperty)iterator.next();
                if (rDFProperty instanceof OWLDatatypeProperty) continue;
                iterator.remove();
            }
            return arrayList;
        }
    };
    private MatrixFilter filter;
    private OWLModel owlModel;
    private MatrixTable table;
    private MatrixTableModel tableModel;

    public MatrixPanel(OWLModel oWLModel, MatrixFilter matrixFilter, MatrixTableModel matrixTableModel) {
        super(oWLModel);
        this.filter = matrixFilter;
        this.owlModel = oWLModel;
        this.tableModel = matrixTableModel;
        this.table = this.createMatrixTable(matrixTableModel);
        this.addRefreshButton();
        this.addAnnotationButtons();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        this.setCenterComponent(jScrollPane);
    }

    private void addRefreshButton() {
        AbstractAction abstractAction = new AbstractAction("Refresh", OWLIcons.getImageIcon("Refresh")){

            public void actionPerformed(ActionEvent actionEvent) {
                MatrixPanel.this.refresh();
            }
        };
        this.addButton(abstractAction);
    }

    private void addAnnotationButtons() {
        JButton jButton = this.addButton(this.addAnnotationPropertyAction);
        this.addAnnotationPropertyAction.activateComboBox(jButton);
    }

    private void addAnnotationProperty(RDFProperty rDFProperty) {
        AnnotationPropertyMatrixColumn annotationPropertyMatrixColumn = new AnnotationPropertyMatrixColumn(rDFProperty);
        this.table.addColumn(annotationPropertyMatrixColumn);
    }

    protected MatrixTable createMatrixTable(MatrixTableModel matrixTableModel) {
        return new MatrixTable(matrixTableModel);
    }

    public void dispose() {
        super.dispose();
        this.tableModel.dispose();
    }

    public MatrixTable getTable() {
        return this.table;
    }

    public MatrixTableModel getTableModel() {
        return this.tableModel;
    }

    public String getTabName() {
        return this.filter.getName();
    }

    private void refresh() {
        this.tableModel.refill();
    }
}

