/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.matrix.EditableMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.SortableMatrixColumn;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AnnotationPropertyMatrixColumn
implements EditableMatrixColumn,
SortableMatrixColumn {
    private RDFProperty property;

    public AnnotationPropertyMatrixColumn(RDFProperty rDFProperty) {
        this.property = rDFProperty;
    }

    public RDFProperty getAnnotationProperty() {
        return this.property;
    }

    public TableCellRenderer getCellRenderer() {
        return new FrameRenderer(){

            public void load(Object object) {
                if (object instanceof RDFResource) {
                    RDFResource rDFResource = (RDFResource)object;
                    object = rDFResource.getPropertyValue(AnnotationPropertyMatrixColumn.this.property);
                }
                if (object == null) {
                    this.clear();
                } else {
                    super.load(object);
                }
            }
        };
    }

    public String getName() {
        return this.property.getName();
    }

    public int getWidth() {
        return 250;
    }

    public Comparator getSortComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                RDFResource rDFResource = (RDFResource)object;
                RDFResource rDFResource2 = (RDFResource)object2;
                Object object3 = rDFResource.getPropertyValue(AnnotationPropertyMatrixColumn.this.property);
                Object object4 = rDFResource2.getPropertyValue(AnnotationPropertyMatrixColumn.this.property);
                if (object3 instanceof Comparable) {
                    if (object4 == null) {
                        return -1;
                    }
                    int n = ((Comparable)object3).compareTo(object4);
                    if (n != 0) {
                        return n;
                    }
                } else if (object4 != null) {
                    return 1;
                }
                return rDFResource.getName().compareTo(rDFResource2.getName());
            }
        };
    }

    public TableCellEditor getTableCellEditor() {
        JTextField jTextField = new JTextField();
        return new DefaultCellEditor(jTextField){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                RDFResource rDFResource = (RDFResource)object;
                if ((object = rDFResource.getPropertyValue(AnnotationPropertyMatrixColumn.this.property)) == null) {
                    object = "";
                }
                return super.getTableCellEditorComponent(jTable, rDFResource.getLocalName(), bl, n, n2);
            }
        };
    }

    public boolean isCellEditable(RDFResource rDFResource) {
        return rDFResource.getPropertyValues(this.property).size() < 2;
    }

    public void setValueAt(RDFResource rDFResource, Object object) {
        if (((String)object).length() == 0) {
            object = null;
        }
        rDFResource.setPropertyValue(this.property, object);
    }
}

