/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.jena;

import com.hp.hpl.jena.ontology.OntModel;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.OntModelProvider;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.jena.JenaSchemagenPanel;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import jena.schemagen;

public class JenaSchemagenAction
extends AbstractOWLModelAction {
    public static final String JENA_SCHEMAGEN_FILE = "JENA-SCHEMAGEN-FILE";
    public static final String JENA_SCHEMAGEN_PACKAGE = "JENA-SCHEMAGEN-PACKAGE";

    public String getMenubarPath() {
        return "Code/1_Java_Code";
    }

    public String getName() {
        return "Generate Java Schema class...";
    }

    public void run(OWLModel oWLModel) {
        OntModelProvider ontModelProvider = (OntModelProvider)((Object)oWLModel);
        OWLProject oWLProject = oWLModel.getOWLProject();
        JenaSchemagenPanel jenaSchemagenPanel = new JenaSchemagenPanel();
        jenaSchemagenPanel.setFileName(oWLProject.getSettingsMap().getString(JENA_SCHEMAGEN_FILE));
        jenaSchemagenPanel.setPackage(oWLProject.getSettingsMap().getString(JENA_SCHEMAGEN_PACKAGE));
        Component component = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
        if (ProtegeUI.getModalDialogFactory().showDialog(component, jenaSchemagenPanel, this.getName(), 11) == 1) {
            oWLProject.getSettingsMap().setString(JENA_SCHEMAGEN_FILE, jenaSchemagenPanel.getFileName());
            oWLProject.getSettingsMap().setString(JENA_SCHEMAGEN_PACKAGE, jenaSchemagenPanel.getPackage());
            File file = new File(jenaSchemagenPanel.getFileName());
            try {
                JenaSchemagenAction.generate(ontModelProvider, file, jenaSchemagenPanel.getPackage());
                ProtegeUI.getModalDialogFactory().showMessageDialog(component, "Schema generated to " + file + ".");
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(component, "Error: " + exception);
            }
        }
    }

    public static void generate(OntModelProvider ontModelProvider, File file, String string) throws Exception {
        OntModel ontModel = ontModelProvider.getOntModel();
        String string2 = ontModel.getNsPrefixURI("");
        File file2 = new File("schemagen-temp.owl");
        JenaOWLModel.save(file2, ontModel, "RDF/XML-ABBREV", string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-a");
        arrayList.add(string2);
        arrayList.add("-n");
        String string3 = file.getName();
        int n = string3.lastIndexOf(46);
        if (n >= 0) {
            string3 = string3.substring(0, n);
        }
        arrayList.add(string3);
        arrayList.add("-i");
        arrayList.add(file2.toURI().toString());
        arrayList.add("-o");
        arrayList.add(file.getAbsolutePath());
        if (string != null) {
            arrayList.add("--package");
            arrayList.add(string);
        }
        arrayList.add("--ontology");
        arrayList.add("--owl");
        try {
            schemagen.main((String[])arrayList.toArray(new String[0]));
        }
        catch (Exception exception) {
            file2.delete();
            throw exception;
        }
        file2.delete();
    }
}

