/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.TransferableCollection;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextAreaPanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;

public class AssertedTypesListPanel
extends SelectableContainer {
    private static final long serialVersionUID = -5577903429790898408L;
    private Action addTypeAction;
    private Action addExpressionAction;
    private SelectableList list;
    private OWLModel owlModel;
    private RDFResource resource;
    private ResourceListener resourceListener = new ResourceAdapter(){

        public void typeAdded(RDFResource rDFResource, RDFSClass rDFSClass) {
            ComponentUtilities.addListValue((JList)AssertedTypesListPanel.this.list, (Object)rDFSClass);
        }

        public void typeRemoved(RDFResource rDFResource, RDFSClass rDFSClass) {
            ComponentUtilities.removeListValue((JList)AssertedTypesListPanel.this.list, (Object)rDFSClass);
        }
    };

    public AssertedTypesListPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.list = ComponentFactory.createSelectableList((Action)this.createDoubleClickAction());
        this.list.setCellRenderer((ListCellRenderer)((Object)new ResourceRenderer(false)));
        this.setSelectable((Selectable)this.list);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Asserted Types", new JScrollPane((Component)this.list));
        oWLLabeledComponent.addHeaderButton(this.createAddTypeAction());
        oWLLabeledComponent.addHeaderButton(this.createAddExpressionAction());
        oWLLabeledComponent.addHeaderButton(this.createRemoveTypeAction());
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)oWLLabeledComponent));
        this.setPreferredSize(new Dimension(0, 100));
        this.updateAddButton();
        this.list.setDragEnabled(true);
        this.list.setTransferHandler((TransferHandler)new FrameTransferHandler());
    }

    public void setResource(RDFResource rDFResource) {
        if (this.resource != null) {
            this.resource.removeResourceListener(this.resourceListener);
        }
        this.resource = rDFResource;
        if (this.resource != null) {
            this.resource.addResourceListener(this.resourceListener);
        }
        this.updateModel();
        this.updateAddButton();
    }

    public void updateModel() {
        SimpleListModel simpleListModel;
        if (this.resource == null) {
            simpleListModel = new DefaultListModel();
        } else {
            Collection collection = this.resource.getRDFTypes();
            simpleListModel = new SimpleListModel(collection);
        }
        this.list.setModel(simpleListModel);
    }

    public void updateAddButton() {
        this.addTypeAction.setEnabled(this.resource != null);
        this.addExpressionAction.setEnabled(this.resource != null);
    }

    private Action createAddTypeAction() {
        this.addTypeAction = new AddAction("Add type...", OWLIcons.getAddIcon("PrimitiveClass")){

            public void onAdd() {
                Set set = ProtegeUI.getSelectionDialogFactory().selectClasses((Component)((Object)AssertedTypesListPanel.this), AssertedTypesListPanel.this.owlModel, "Select type to add");
                for (RDFSClass rDFSClass : set) {
                    AssertedTypesListPanel.this.resource.addProtegeType(rDFSClass);
                }
            }
        };
        return this.addTypeAction;
    }

    private Action createRemoveTypeAction() {
        return new RemoveAction("Remove selected type", (Selectable)this.list, OWLIcons.getRemoveIcon("PrimitiveClass")){

            public void onRemove(Object object) {
                if (object instanceof RDFSClass) {
                    if (AssertedTypesListPanel.this.resource.getRDFTypes().size() > 1) {
                        AssertedTypesListPanel.this.resource.removeProtegeType((RDFSClass)object);
                    } else {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(AssertedTypesListPanel.this.owlModel, "Resources must have at least one remaining type.");
                    }
                }
            }
        };
    }

    private Action createAddExpressionAction() {
        this.addExpressionAction = new AddAction("Add OWL class expression as type...", OWLIcons.getCreateIcon("OWLAnonymousClass")){

            public void onAdd() {
                OWLModel oWLModel = AssertedTypesListPanel.this.resource.getOWLModel();
                String string = OWLTextAreaPanel.showEditDialog((Component)((Object)AssertedTypesListPanel.this), oWLModel, null);
                if (string != null) {
                    try {
                        OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
                        RDFSClass rDFSClass = oWLClassParser.parseClass(oWLModel, string);
                        if (rDFSClass != null) {
                            AssertedTypesListPanel.this.resource.addProtegeType(rDFSClass);
                        }
                    }
                    catch (OWLClassParseException oWLClassParseException) {
                        ModalDialog.showMessageDialog((Component)((Object)AssertedTypesListPanel.this), (String)"Invalid class expression", (String)"Invalid expression");
                        return;
                    }
                }
            }
        };
        return this.addExpressionAction;
    }

    private Action createDoubleClickAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Collection collection = AssertedTypesListPanel.this.list.getSelection();
                for (Object e : collection) {
                    if (e instanceof RDFResource) {
                        RDFResource rDFResource = (RDFResource)e;
                        if (rDFResource instanceof OWLAnonymousClass) {
                            AssertedTypesListPanel.this.editAnonExpression((OWLAnonymousClass)rDFResource);
                            continue;
                        }
                        AssertedTypesListPanel.this.owlModel.getProject().show((Instance)e);
                        continue;
                    }
                    if (!(e instanceof Instance)) continue;
                    AssertedTypesListPanel.this.owlModel.getProject().show((Instance)e);
                }
            }
        };
    }

    protected void editAnonExpression(OWLAnonymousClass oWLAnonymousClass) {
        OWLModel oWLModel = this.resource.getOWLModel();
        String string = OWLTextAreaPanel.showEditDialog((Component)((Object)this), oWLModel, oWLAnonymousClass);
        if (string != null) {
            RDFSClass rDFSClass = null;
            try {
                OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
                rDFSClass = oWLClassParser.parseClass(oWLModel, string);
            }
            catch (OWLClassParseException oWLClassParseException) {
                ModalDialog.showMessageDialog((Component)((Object)this), (String)"Invalid class expression", (String)"Invalid expression");
                return;
            }
            if (rDFSClass != null) {
                try {
                    oWLModel.beginTransaction("Change type of " + this.resource.getBrowserText() + " from: '" + oWLAnonymousClass.getBrowserText() + "' to: '" + string + "'", this.resource.getName());
                    this.resource.addProtegeType(rDFSClass);
                    this.resource.removeProtegeType(oWLAnonymousClass);
                    oWLModel.commitTransaction();
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.WARNING, "Change type for " + this.resource.getName() + " failed.", exception);
                    oWLModel.rollbackTransaction();
                    ModalDialog.showMessageDialog((Component)((Object)this), (String)("Changing the type of " + this.resource.getBrowserText() + " failed.\nSee console for details."), (String)"Error");
                    return;
                }
                try {
                    this.list.setSelectedValue((Object)rDFSClass);
                }
                catch (Exception exception) {
                    Log.emptyCatchBlock((Throwable)exception);
                }
            }
        }
    }

    private class FrameTransferHandler
    extends TransferHandler {
        private FrameTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            Collection collection = AssertedTypesListPanel.this.getSelection();
            return collection.isEmpty() ? null : new TransferableCollection(collection);
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            return true;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                for (RDFSClass rDFSClass : AssertedTypesListPanel.this.getSelection()) {
                    int n2 = 0;
                    Log.getLogger().info("Move " + rDFSClass + " to: " + n2);
                    AssertedTypesListPanel.this.resource.moveDirectType(rDFSClass, n2);
                    AssertedTypesListPanel.this.updateModel();
                }
            }
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }
    }
}

