/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.MakeCopiesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.Transaction;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.ui.BrowserTextListFinder;
import edu.stanford.smi.protege.ui.ConfigureAction;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.FrameWithBrowserTextComparator;
import edu.stanford.smi.protege.util.GetInstancesAndBrowserTextJob;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.individuals.InstancesList;
import edu.stanford.smi.protegex.owl.ui.individuals.MultiSlotPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertedInstancesListPanel
extends SelectableContainer
implements Disposable {
    private OWLModel owlModel;
    private Collection<Cls> classes = Collections.emptyList();
    private AllowableAction createAction;
    private AllowableAction createAnonymousAction;
    private AllowableAction copyAction;
    private AllowableAction deleteAction;
    private HeaderComponent header;
    private OWLLabeledComponent lc;
    private InstancesList list;
    private Collection<Instance> listenedToInstances = new ArrayList<Instance>();
    private boolean showSubclassInstances;
    private static final int SORT_LIMIT = ApplicationProperties.getIntegerProperty((String)"ui.DirectInstancesList.sort_limit", (int)1000);
    private ClsListener _clsListener = new ClsAdapter(){

        public void directInstanceAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            Instance instance = clsEvent.getInstance();
            FrameWithBrowserText frameWithBrowserText = new FrameWithBrowserText((Frame)instance, instance.getBrowserText(), instance.getDirectTypes());
            if (!AssertedInstancesListPanel.this.getModel().contains((Object)frameWithBrowserText)) {
                ComponentUtilities.addListValue((JList)((Object)AssertedInstancesListPanel.this.list), (Object)frameWithBrowserText);
                instance.addFrameListener(AssertedInstancesListPanel.this._instanceFrameListener);
            }
        }

        public void directInstanceRemoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            AssertedInstancesListPanel.this.removeInstanceListener(clsEvent.getInstance());
            ComponentUtilities.removeListValue((JList)((Object)AssertedInstancesListPanel.this.list), (Object)new FrameWithBrowserText((Frame)clsEvent.getInstance()));
        }
    };
    private FrameListener _clsFrameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            super.ownSlotValueChanged(frameEvent);
            AssertedInstancesListPanel.this.updateButtons();
        }
    };
    private FrameListener _instanceFrameListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent frameEvent) {
            Frame frame = frameEvent.getFrame();
            ComponentUtilities.replaceListValue((JList)((Object)AssertedInstancesListPanel.this.list), (Object)new FrameWithBrowserText(frame), (Object)new FrameWithBrowserText(frame, frame.getBrowserText(), ((Instance)frame).getDirectTypes()));
            AssertedInstancesListPanel.this.repaint();
        }

        public void frameReplaced(FrameEvent frameEvent) {
            Instance instance = (Instance)frameEvent.getFrame();
            Instance instance2 = (Instance)frameEvent.getNewFrame();
            ComponentUtilities.replaceListValue((JList)((Object)AssertedInstancesListPanel.this.list), (Object)new FrameWithBrowserText((Frame)instance, instance.getBrowserText(), instance.getDirectTypes()), (Object)new FrameWithBrowserText((Frame)instance2, instance2.getBrowserText(), instance2.getDirectTypes()));
        }
    };

    public AssertedInstancesListPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        Action action = this.createViewAction();
        this.list = new InstancesList(action);
        this.createListRenderer();
        this.lc = new OWLLabeledComponent(null, ComponentFactory.createScrollPane((JComponent)((Object)this.list)));
        this.addButtons(action, this.lc);
        this.lc.setFooterComponent((JComponent)new BrowserTextListFinder((JList)((Object)this.list), ResourceKey.INSTANCE_SEARCH_FOR));
        this.lc.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)((Object)this.lc), "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createHeader(), "North");
        this.add(jPanel, "North");
        this.setSelectable(this.list);
        this.lc.setHeaderLabel("Asserted Instances");
    }

    private void updateLabel() {
        String string;
        BrowserSlotPattern browserSlotPattern;
        Cls cls = this.getSoleAllowedCls();
        BrowserSlotPattern browserSlotPattern2 = browserSlotPattern = cls == null ? null : cls.getBrowserSlotPattern();
        if (browserSlotPattern == null) {
            string = null;
        } else if (browserSlotPattern.isSimple()) {
            string = browserSlotPattern.getFirstSlot().getBrowserText();
            if (":NAME".equals(string)) {
                string = "Asserted Instances";
            }
        } else {
            string = "multiple properties";
        }
        this.lc.setHeaderLabel(string);
    }

    private HeaderComponent createHeader() {
        JLabel jLabel = ComponentFactory.createLabel();
        String string = LocalizedText.getText((ResourceKey)ResourceKey.INSTANCE_BROWSER_TITLE);
        String string2 = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL);
        this.header = new HeaderComponent(string, string2, (JComponent)jLabel);
        this.header.setColor(Colors.getInstanceColor());
        return this.header;
    }

    private void fixRenderer() {
        FrameRenderer frameRenderer = (FrameRenderer)this.list.getCellRenderer();
        frameRenderer.setDisplayType(this.showSubclassInstances);
    }

    protected void addButtons(Action action, LabeledComponent labeledComponent) {
        labeledComponent.addHeaderButton(this.createConfigureAction());
        labeledComponent.addHeaderButton(this.createCreateAction());
        labeledComponent.addHeaderButton(this.createCopyAction());
        labeledComponent.addHeaderButton(this.createDeleteAction());
        labeledComponent.addHeaderButton(this.createCreateAnonymousAction());
    }

    private void addClsListeners() {
        for (Cls cls : this.classes) {
            cls.addClsListener(this._clsListener);
            cls.addFrameListener(this._clsFrameListener);
        }
    }

    private void addInstanceListeners() {
        SimpleListModel simpleListModel = this.getModel();
        int n = this.list.getFirstVisibleIndex();
        int n2 = this.list.getLastVisibleIndex();
        if (n < 0) {
            return;
        }
        for (int i = n; i < n2 + 1; ++i) {
            FrameWithBrowserText frameWithBrowserText = (FrameWithBrowserText)simpleListModel.getElementAt(i);
            Instance instance = (Instance)frameWithBrowserText.getFrame();
            this.addInstanceListener(instance);
        }
    }

    private void removeInstanceListeners() {
        for (Instance instance : this.listenedToInstances) {
            instance.removeFrameListener(this._instanceFrameListener);
        }
        this.listenedToInstances.clear();
    }

    private void addInstanceListener(Instance instance) {
        instance.addFrameListener(this._instanceFrameListener);
        this.listenedToInstances.add(instance);
    }

    protected Action createCreateAction() {
        this.createAction = new CreateAction("Create instance ", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

            public void onCreate() {
                if (!AssertedInstancesListPanel.this.classes.isEmpty()) {
                    RDFSClass rDFSClass = (RDFSClass)CollectionUtilities.getFirstItem((Collection)AssertedInstancesListPanel.this.classes);
                    final String string = AssertedInstancesListPanel.this.owlModel.createNewResourceName(NamespaceUtil.getLocalName(rDFSClass.getName()));
                    Transaction<Instance> transaction = new Transaction<Instance>((KnowledgeBase)AssertedInstancesListPanel.this.owlModel, "Create Individual: " + NamespaceUtil.getLocalName(string) + " of " + CollectionUtilities.toString((Collection)AssertedInstancesListPanel.this.classes), string){
                        private Instance instance;

                        public boolean doOperations() {
                            Cls cls;
                            this.instance = AssertedInstancesListPanel.this.owlModel.createInstance(string, AssertedInstancesListPanel.this.classes);
                            if (this.instance instanceof Cls && (cls = (Cls)this.instance).getDirectSuperclassCount() == 0) {
                                cls.addDirectSuperclass((Cls)AssertedInstancesListPanel.this.owlModel.getOWLThingClass());
                            }
                            return true;
                        }

                        public Instance getResult() {
                            return this.instance;
                        }
                    };
                    transaction.execute();
                    AssertedInstancesListPanel.this.list.setSelectedValue(new FrameWithBrowserText((Frame)transaction.getResult()), true);
                }
            }
        };
        return this.createAction;
    }

    protected Action createCreateAnonymousAction() {
        this.createAnonymousAction = new CreateAction("Create anonymous instance", OWLIcons.getCreateIndividualIcon("RDFAnonIndividual")){

            public void onCreate() {
                if (!AssertedInstancesListPanel.this.classes.isEmpty()) {
                    Cls cls;
                    String string = AssertedInstancesListPanel.this.owlModel.getNextAnonymousResourceName();
                    Instance instance = AssertedInstancesListPanel.this.owlModel.createInstance(new FrameID(string), AssertedInstancesListPanel.this.classes, false);
                    if (instance instanceof Cls && (cls = (Cls)instance).getDirectSuperclassCount() == 0) {
                        cls.addDirectSuperclass((Cls)AssertedInstancesListPanel.this.owlModel.getOWLThingClass());
                    }
                    AssertedInstancesListPanel.this.list.setSelectedValue(new FrameWithBrowserText((Frame)instance), true);
                }
            }
        };
        return this.createAnonymousAction;
    }

    protected Action createConfigureAction() {
        return new ConfigureAction(){

            public void loadPopupMenu(JPopupMenu jPopupMenu) {
                jPopupMenu.add(AssertedInstancesListPanel.this.createSetDisplaySlotMenuItem());
                jPopupMenu.add(AssertedInstancesListPanel.this.createSetDisplaySlotsMenuItem());
                jPopupMenu.add(AssertedInstancesListPanel.this.createShowAllInstancesAction());
            }
        };
    }

    protected JMenuItem createShowAllInstancesAction() {
        AbstractAction abstractAction = new AbstractAction("Show Subclass Instances"){

            public void actionPerformed(ActionEvent actionEvent) {
                AssertedInstancesListPanel.this.setShowAllInstances(!AssertedInstancesListPanel.this.showSubclassInstances);
            }
        };
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(abstractAction);
        jCheckBoxMenuItem.setSelected(this.showSubclassInstances);
        return jCheckBoxMenuItem;
    }

    private void setShowAllInstances(boolean bl) {
        this.showSubclassInstances = bl;
        this.reload();
        this.fixRenderer();
    }

    protected Cls getSoleAllowedCls() {
        Cls cls = this.classes.size() == 1 ? (Cls)CollectionUtilities.getFirstItem(this.classes) : null;
        return cls;
    }

    protected JMenuItem createSetDisplaySlotMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Set Display Property");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Cls cls = AssertedInstancesListPanel.this.getSoleAllowedCls();
                ArrayList<Slot> arrayList = new ArrayList<Slot>(cls.getVisibleTemplateSlots());
                arrayList.add(cls.getKnowledgeBase().getNameSlot());
                Collections.sort(arrayList);
                RDFProperty rDFProperty = ProtegeUI.getSelectionDialogFactory().selectProperty((Component)((Object)AssertedInstancesListPanel.this), AssertedInstancesListPanel.this.owlModel, arrayList);
                if (rDFProperty != null) {
                    cls.setDirectBrowserSlot((Slot)rDFProperty);
                }
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createSetDisplaySlotsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(this.createSetDisplaySlotMultipleAction());
        jMenuItem.setEnabled(true);
        return jMenuItem;
    }

    protected Action createSetDisplaySlotMultipleAction() {
        return new AbstractAction("Set Display Properties"){
            private static final long serialVersionUID = -5884471155567559812L;

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserSlotPattern browserSlotPattern;
                Cls cls = AssertedInstancesListPanel.this.getSoleAllowedCls();
                BrowserSlotPattern browserSlotPattern2 = AssertedInstancesListPanel.this.getSoleAllowedCls().getBrowserSlotPattern();
                MultiSlotPanel multiSlotPanel = new MultiSlotPanel(browserSlotPattern2, cls);
                int n = ModalDialog.showDialog((Component)((Object)AssertedInstancesListPanel.this), (Component)multiSlotPanel, (String)"Multislot Display Pattern", (int)11);
                if (n == 1 && (browserSlotPattern = multiSlotPanel.getBrowserTextPattern()) != null) {
                    cls.setDirectBrowserSlotPattern(browserSlotPattern);
                }
                AssertedInstancesListPanel.this.updateLabel();
                AssertedInstancesListPanel.this.repaint();
            }
        };
    }

    protected Action createDeleteAction() {
        this.deleteAction = new DeleteInstancesAction((Selectable)this);
        return this.deleteAction;
    }

    protected Action createCopyAction() {
        this.copyAction = new MakeCopiesAction(ResourceKey.INSTANCE_COPY, (Selectable)this){

            protected Instance copy(Instance instance, boolean bl) {
                Instance instance2 = super.copy(instance, bl);
                AssertedInstancesListPanel.this.setSelectedInstance(instance2);
                return instance2;
            }
        };
        return this.copyAction;
    }

    protected Action createReferencersAction() {
        return new ReferencersAction(ResourceKey.INSTANCE_VIEW_REFERENCES, (Selectable)this);
    }

    protected Action createViewAction() {
        return new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){

            public void onView(Object object) {
                AssertedInstancesListPanel.this.owlModel.getProject().show((Instance)object);
            }
        };
    }

    public void dispose() {
        this.removeClsListeners();
        this.removeInstanceListeners();
    }

    public JComponent getDragComponent() {
        return this.list;
    }

    private SimpleListModel getModel() {
        return (SimpleListModel)this.list.getModel();
    }

    private boolean isSelectionEditable() {
        boolean bl = true;
        for (Instance instance : this.getSelection()) {
            if (instance.isEditable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void onSelectionChange() {
        boolean bl = this.isSelectionEditable();
        ComponentUtilities.setDragAndDropEnabled((JComponent)((Object)this.list), (boolean)bl);
        this.updateButtons();
    }

    private void removeInstanceListener(Instance instance) {
        instance.removeFrameListener(this._instanceFrameListener);
        this.listenedToInstances.remove(instance);
    }

    private void removeClsListeners() {
        for (Cls cls : this.classes) {
            cls.removeClsListener(this._clsListener);
            cls.removeFrameListener(this._clsFrameListener);
        }
    }

    public void setClses(Collection collection) {
        this.removeClsListeners();
        this.classes = new ArrayList<Cls>(collection);
        this.list.setClasses(collection);
        this.reload();
        this.updateButtons();
        this.addClsListeners();
    }

    public void reload() {
        this.removeInstanceListeners();
        this.getModel().setValues(this.getFramesWithBrowserText(this.classes));
        this.addInstanceListeners();
        this.reloadHeader(this.classes);
        this.updateLabel();
    }

    private void reloadHeader(Collection collection) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        Icon icon = null;
        for (Object object2 : collection) {
            if (icon == null) {
                icon = object2.getIcon();
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(object2.getBrowserText());
        }
        object2 = (JLabel)this.header.getComponent();
        ((JLabel)object2).setText(stringBuffer.toString());
        ((JLabel)object2).setIcon(icon);
    }

    private static Collection removeHiddenInstances(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            if (instance.isVisible()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public void setSelectedInstance(Instance instance) {
        this.list.setSelectedValue(new FrameWithBrowserText((Frame)instance), true);
        this.updateButtons();
    }

    private void updateButtons() {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(this.classes);
        this.createAction.setEnabled(cls == null ? false : cls.isConcrete());
        this.createAnonymousAction.setEnabled(cls == null ? false : cls.isConcrete());
        Instance instance = (Instance)this.getSoleSelection();
        boolean bl = instance != null && instance instanceof SimpleInstance;
        this.copyAction.setAllowed(bl);
    }

    private void createListRenderer() {
        FrameRenderer frameRenderer = new FrameRenderer(){

            public void load(Object object) {
                if (object instanceof FrameWithBrowserText) {
                    this.showFrameWithBrowserText((FrameWithBrowserText)object);
                } else {
                    super.load(object);
                }
            }

            private void showFrameWithBrowserText(FrameWithBrowserText frameWithBrowserText) {
                this.setMainText(StringUtilities.unquote((String)frameWithBrowserText.getBrowserText()));
                if (frameWithBrowserText.getFrame() != null) {
                    this.setMainIcon(frameWithBrowserText.getFrame().getIcon());
                }
            }
        };
        this.list.setCellRenderer((ListCellRenderer)frameRenderer);
    }

    public Collection getSelection() {
        Collection collection = super.getSelection();
        if (collection == null) {
            return null;
        }
        HashSet<Instance> hashSet = new HashSet<Instance>();
        for (FrameWithBrowserText frameWithBrowserText : collection) {
            hashSet.add((Instance)frameWithBrowserText.getFrame());
        }
        return hashSet;
    }

    @Deprecated
    public void setShowDisplaySlotPanel(boolean bl) {
    }

    private Collection<FrameWithBrowserText> getFramesWithBrowserText(Collection<Cls> collection) {
        if (!this.showSubclassInstances && this.useCacheHeuristics() && this.owlModel.getProject().isMultiUserClient() && this.hasOnlyDataBrowserSlots(collection) && this.isCached(collection)) {
            return this.getValuesFromCache(collection);
        }
        GetInstancesAndBrowserTextJob getInstancesAndBrowserTextJob = new GetInstancesAndBrowserTextJob((KnowledgeBase)this.owlModel, collection, !this.showSubclassInstances);
        return getInstancesAndBrowserTextJob.execute();
    }

    private boolean hasOnlyDataBrowserSlots(Collection<Cls> collection) {
        for (Cls cls : collection) {
            BrowserSlotPattern browserSlotPattern = cls.getBrowserSlotPattern();
            if (browserSlotPattern == null) continue;
            List list = browserSlotPattern.getSlots();
            for (Slot slot : list) {
                if (slot.getValueType() != ValueType.INSTANCE && slot.getValueType() != ValueType.CLS) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isCached(Collection<Cls> collection) {
        for (Cls cls : collection) {
            if (!RemoteClientFrameStore.isCached((Frame)cls, (Slot)this.owlModel.getSystemFrames().getDirectInstancesSlot(), null, (boolean)false)) {
                return false;
            }
            Collection collection2 = cls.getDirectInstances();
            for (Instance instance : collection2) {
                if (RemoteClientFrameStore.isCacheComplete((Frame)instance)) continue;
                return false;
            }
        }
        return true;
    }

    private List<FrameWithBrowserText> getValuesFromCache(Collection<Cls> collection) {
        ArrayList<FrameWithBrowserText> arrayList = new ArrayList<FrameWithBrowserText>();
        for (Cls cls : collection) {
            Collection collection2 = this.showSubclassInstances ? cls.getInstances() : cls.getDirectInstances();
            for (Instance instance : collection2) {
                arrayList.add(new FrameWithBrowserText((Frame)instance, instance.getBrowserText(), instance.getDirectTypes()));
            }
        }
        Collections.sort(arrayList, new FrameWithBrowserTextComparator());
        return arrayList;
    }

    private boolean useCacheHeuristics() {
        return ApplicationProperties.getBooleanProperty((String)"owl.ui.use.cache.heuristics", (boolean)true);
    }
}

