/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree.server;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStoreManager;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.ui.importstree.server.ActiveOntologyFrameStoreHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class SetActiveOntologyJob
extends ProtegeJob {
    private static final long serialVersionUID = 7139921119966372858L;
    private OWLOntology ontology;

    public SetActiveOntologyJob(OWLModel oWLModel, OWLOntology oWLOntology) {
        super((KnowledgeBase)oWLModel);
        this.ontology = oWLOntology;
    }

    public Boolean run() throws ProtegeException {
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        if (!((DefaultOWLOntology)this.ontology).isAssociatedTriplestoreEditable()) {
            return false;
        }
        OWLFrameStoreManager oWLFrameStoreManager = oWLModel.getFrameStoreManager();
        ActiveOntologyFrameStoreHandler activeOntologyFrameStoreHandler = (ActiveOntologyFrameStoreHandler)((Object)oWLFrameStoreManager.getFrameStoreFromClass(ActiveOntologyFrameStoreHandler.class));
        if (activeOntologyFrameStoreHandler == null) {
            activeOntologyFrameStoreHandler = new ActiveOntologyFrameStoreHandler(oWLModel);
            FrameStore frameStore = (FrameStore)Proxy.newProxyInstance(OWLModel.class.getClassLoader(), new Class[]{FrameStore.class}, (InvocationHandler)((Object)activeOntologyFrameStoreHandler));
            oWLFrameStoreManager.insertFrameStore(frameStore, 1);
        }
        activeOntologyFrameStoreHandler.setActiveOntology(this.ontology);
        return true;
    }

    public Boolean execute() throws ProtegeException {
        return (Boolean)super.execute();
    }

    public void localize(KnowledgeBase knowledgeBase) {
        super.localize(knowledgeBase);
        if (this.ontology != null) {
            LocalizeUtils.localize((Object)this.ontology, (KnowledgeBase)knowledgeBase);
        }
    }
}

