/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree.server;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.server.metaproject.OwlMetaProjectConstants;
import java.util.WeakHashMap;

public class CheckSetActiveImportAllowedJob
extends ProtegeJob {
    private static final long serialVersionUID = 7234800355325524952L;
    private OWLOntology ontology;
    private static WeakHashMap<OWLOntology, Boolean> cachedResults = new WeakHashMap();
    public static String ALLOW_MULTIUSER_SET_ACTIVE_ONTOLOGY = "allow.multiuser.client.set.active.ontology";

    public CheckSetActiveImportAllowedJob(OWLOntology oWLOntology) {
        super((KnowledgeBase)oWLOntology.getOWLModel());
        this.ontology = oWLOntology;
    }

    public Boolean run() throws ProtegeException {
        if (!(!this.getKnowledgeBase().getProject().isMultiUserServer() || ApplicationProperties.getBooleanProperty((String)ALLOW_MULTIUSER_SET_ACTIVE_ONTOLOGY, (boolean)false) && this.serverSideCheckOperationAllowed(OwlMetaProjectConstants.SET_ACTIVE_IMPORT))) {
            return false;
        }
        return ((DefaultOWLOntology)this.ontology).isAssociatedTriplestoreEditable();
    }

    public Boolean execute() throws ProtegeException {
        Boolean bl = cachedResults.get(this.ontology);
        if (bl == null) {
            bl = (Boolean)super.execute();
            cachedResults.put(this.ontology, bl);
        }
        return bl;
    }

    public void localize(KnowledgeBase knowledgeBase) {
        super.localize(knowledgeBase);
        if (this.ontology != null) {
            LocalizeUtils.localize((Object)this.ontology, (KnowledgeBase)knowledgeBase);
        }
    }
}

