/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree.server;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ActiveOntologyFrameStoreHandler
extends AbstractFrameStoreInvocationHandler {
    private static Logger log = Log.getLogger(ActiveOntologyFrameStoreHandler.class);
    private OWLModel owlModel;
    private Map<RemoteSession, NarrowFrameStore> activeFrameStoreMap = new HashMap<RemoteSession, NarrowFrameStore>();
    private NarrowFrameStore topFrameStore;
    private MergingNarrowFrameStore mnfs;
    private static Set<Method> transactionMethods = new HashSet<Method>();

    public ActiveOntologyFrameStoreHandler(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.topFrameStore = oWLModel.getTripleStoreModel().getTopTripleStore().getNarrowFrameStore();
        this.mnfs = MergingNarrowFrameStore.get((KnowledgeBase)oWLModel);
    }

    public void setActiveOntology(OWLOntology oWLOntology) {
        TransactionMonitor transactionMonitor = this.getDelegate().getTransactionStatusMonitor();
        if (transactionMonitor != null && transactionMonitor.inTransaction()) {
            throw new IllegalStateException("Can't change the active ontology while in a transaction");
        }
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getHomeTripleStore(oWLOntology);
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        if (narrowFrameStore.equals(this.topFrameStore)) {
            this.activeFrameStoreMap.remove(ServerFrameStore.getCurrentSession());
        } else {
            this.activeFrameStoreMap.put(ServerFrameStore.getCurrentSession(), narrowFrameStore);
        }
    }

    protected void executeQuery(Query query, QueryCallback queryCallback) {
        this.getDelegate().executeQuery(query, queryCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleInvoke(Method method, Object[] objectArray) {
        NarrowFrameStore narrowFrameStore = this.activeFrameStoreMap.get(ServerFrameStore.getCurrentSession());
        if (ActiveOntologyFrameStoreHandler.isQuery((Method)method) || narrowFrameStore == null) {
            return this.invoke(method, objectArray);
        }
        if (transactionMethods.contains(method)) {
            this.mnfs.setActiveFrameStore(this.topFrameStore);
            return this.invoke(method, objectArray);
        }
        try {
            this.mnfs.setActiveFrameStore(narrowFrameStore);
            Object object = this.invoke(method, objectArray);
            return object;
        }
        finally {
            this.mnfs.setActiveFrameStore(this.topFrameStore);
        }
    }

    static {
        try {
            transactionMethods.add(FrameStore.class.getMethod("beginTransaction", String.class));
            transactionMethods.add(FrameStore.class.getMethod("commitTransaction", new Class[0]));
            transactionMethods.add(FrameStore.class.getMethod("rollbackTransaction", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.severe("Could not install active ontology configurtion on the server.");
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

