/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class ImportsTreeNode
extends LazyTreeNode {
    private FrameListener _frameListener;

    public ImportsTreeNode(LazyTreeNode lazyTreeNode, RDFResource rDFResource) {
        super(lazyTreeNode, (Object)rDFResource);
        rDFResource.addFrameListener(this.getFrameListener());
    }

    protected LazyTreeNode createNode(Object object) {
        return new ImportsTreeNode(this, (RDFResource)object);
    }

    protected int getChildObjectCount() {
        RDFResource rDFResource = this.getResource();
        if (rDFResource instanceof OWLOntology) {
            OWLOntology oWLOntology = (OWLOntology)rDFResource;
            return oWLOntology.getImports().size();
        }
        return 0;
    }

    protected Collection getChildObjects() {
        RDFResource rDFResource = this.getResource();
        if (rDFResource instanceof OWLOntology) {
            OWLOntology oWLOntology = (OWLOntology)rDFResource;
            return oWLOntology.getImportResources();
        }
        return Collections.EMPTY_LIST;
    }

    protected Comparator getComparator() {
        return null;
    }

    private RDFResource getResource() {
        return (RDFResource)this.getUserObject();
    }

    protected FrameListener getFrameListener() {
        if (this._frameListener == null) {
            this._frameListener = new FrameAdapter(){

                public void frameReplaced(FrameEvent frameEvent) {
                    Frame frame = frameEvent.getFrame();
                    Frame frame2 = frameEvent.getNewFrame();
                    RDFResource rDFResource = ImportsTreeNode.this.getResource();
                    if (rDFResource != null && rDFResource.equals(frame)) {
                        OWLModel oWLModel = rDFResource.getOWLModel();
                        OWLUtil.synchronizeTripleStoreAfterOntologyRename(oWLModel, frame.getName(), (OWLOntology)frame2);
                        oWLModel.getTripleStoreModel().getTopTripleStore().setOriginalXMLBase(frame2.getName());
                        ImportsTreeNode.this.reload(frame2);
                    }
                }
            };
        }
        return this._frameListener;
    }

    protected void dispose() {
        super.dispose();
        if (this.getResource() != null) {
            this.getResource().removeFrameListener(this._frameListener);
        }
    }
}

