/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreeNode;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerRenderer;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerTreeNode;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerTreeRoot;
import edu.stanford.smi.protegex.owl.ui.subsumption.TooltippedSelectableTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ExplorerTreePanel
extends SelectableContainer
implements Hierarchy {
    private ExplorerFilter filter;
    private HeaderComponent headerComponent;
    private JLabel hlabel;
    private LabeledComponent lc;
    private JPanel mainPanel;
    private OWLModel owlModel;
    private static final int MAX_EXPANSIONS = 100;
    private RDFSClass root;
    private TooltippedSelectableTree tree;
    private String title;
    private Action viewAction;
    private ModelListener modelListener = new ModelAdapter(){

        public void classDeleted(RDFSClass rDFSClass) {
            if (rDFSClass.equals(ExplorerTreePanel.this.root)) {
                OWLNamedClass oWLNamedClass = ExplorerTreePanel.this.owlModel.getOWLThingClass();
                ExplorerTreePanel.this.setRoot(oWLNamedClass);
            }
        }
    };

    public ExplorerTreePanel(RDFSClass rDFSClass, ExplorerFilter explorerFilter, String string, boolean bl) {
        this.filter = explorerFilter;
        this.root = rDFSClass;
        this.title = string;
        this.setPreferredSize(new Dimension(260, 200));
        this.setMinimumSize(new Dimension(100, 100));
        this.owlModel = rDFSClass.getOWLModel();
        this.viewAction = this.createViewClassAction();
        this.tree = this.createTree();
        this.owlModel.addModelListener(this.modelListener);
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add("Center", new JScrollPane((Component)((Object)this.tree)));
        String string2 = this.getTitle();
        this.lc = new OWLLabeledComponent(string2, this.mainPanel, true, false);
        this.viewAction.setEnabled(true);
        this.setLayout(new BorderLayout());
        if (bl) {
            this.hlabel = ComponentFactory.createLabel((String)rDFSClass.getBrowserText(), (Icon)ProtegeUI.getIcon(rDFSClass), (int)2);
            this.headerComponent = new HeaderComponent("SUPERCLASS EXPLORER", "For Class: ", (JComponent)this.hlabel);
            this.add("North", (Component)this.headerComponent);
        }
        this.add("Center", (Component)this.lc);
    }

    private TooltippedSelectableTree createTree() {
        ExplorerTreeRoot explorerTreeRoot = new ExplorerTreeRoot(this.root, this.filter);
        TooltippedSelectableTree tooltippedSelectableTree = this.createSelectableTree(this.viewAction, explorerTreeRoot);
        tooltippedSelectableTree.setSelectionRow(0);
        tooltippedSelectableTree.setAutoscrolls(true);
        this.setSelectable((Selectable)tooltippedSelectableTree);
        tooltippedSelectableTree.setCellRenderer((TreeCellRenderer)((Object)new ExplorerRenderer()));
        tooltippedSelectableTree.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                ExplorerTreePanel.this.updateActions();
            }
        });
        tooltippedSelectableTree.addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)((Object)tooltippedSelectableTree)){

            public JPopupMenu getPopupMenu() {
                return ExplorerTreePanel.this.getPopupMenu();
            }
        });
        return tooltippedSelectableTree;
    }

    public Hierarchy createClone() {
        return new ExplorerTreePanel(this.root, this.filter, this.title, true);
    }

    private Action createCollapseAllAction() {
        return new AbstractAction("Collapse", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentUtilities.fullSelectionCollapse((JTree)ExplorerTreePanel.this.getTree());
            }
        };
    }

    private Action createExpandAllAction() {
        return new AbstractAction("Expand", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentUtilities.fullSelectionExpand((JTree)ExplorerTreePanel.this.getTree(), (int)100);
            }
        };
    }

    protected JPopupMenu createPopupMenu(RDFSClass rDFSClass) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.createExpandAllAction());
        jPopupMenu.add(this.createCollapseAllAction());
        if (rDFSClass instanceof RDFResource) {
            ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)this), (RDFResource)rDFSClass);
        }
        return jPopupMenu;
    }

    protected TooltippedSelectableTree createSelectableTree(Action action, LazyTreeRoot lazyTreeRoot) {
        TooltippedSelectableTree tooltippedSelectableTree = new TooltippedSelectableTree(action, lazyTreeRoot);
        tooltippedSelectableTree.setCellRenderer((TreeCellRenderer)FrameRenderer.createInstance());
        return tooltippedSelectableTree;
    }

    protected Action createViewClassAction() {
        return new ViewAction("View selected class", this){

            public void onView(Object object) {
                ExplorerTreePanel.this.owlModel.getProject().show((Instance)((RDFSClass)object));
            }
        };
    }

    public void dispose() {
        super.dispose();
        this.owlModel.removeModelListener(this.modelListener);
    }

    public void expandToFillSpace() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this.tree.getParent().getHeight();
        n /= this.tree.getRowHeight();
        LazyTreeNode lazyTreeNode = (LazyTreeNode)this.tree.getModel().getRoot();
        arrayList.add(lazyTreeNode);
        TreeNode treeNode = lazyTreeNode.getChildAt(0);
        arrayList.add(treeNode);
        for (int i = 2; i < n && treeNode.getChildCount() > 0 && treeNode.getChildAt(0).getChildCount() > 0; ++i) {
            arrayList.add(treeNode.getChildAt(0));
            treeNode = treeNode.getChildAt(0);
        }
        TreePath treePath = new TreePath(arrayList.toArray());
        this.tree.expandPath(treePath);
    }

    public void extendSelection(RDFSClass rDFSClass) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)rDFSClass);
    }

    public JTree getClassesTree() {
        return this.getTree();
    }

    public RDFSClass getDisplayParent() {
        TreePath treePath = this.getTree().getSelectionModel().getLeadSelectionPath().getParentPath();
        LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath.getLastPathComponent();
        Object object = lazyTreeNode.getUserObject();
        return object instanceof RDFSClass ? (RDFSClass)object : null;
    }

    public HeaderComponent getHeaderComponent() {
        return this.headerComponent;
    }

    protected LabeledComponent getLabeledComponent() {
        return this.lc;
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = null;
        Collection collection = this.getSelection();
        if (collection.size() == 1) {
            RDFSClass rDFSClass = (RDFSClass)CollectionUtilities.getFirstItem((Collection)collection);
            jPopupMenu = this.createPopupMenu(rDFSClass);
        }
        return jPopupMenu;
    }

    public RDFSClass getSelectedClass() {
        JTree jTree = this.getTree();
        if (jTree.getSelectionCount() == 1) {
            TreePath treePath = jTree.getSelectionPath();
            ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)((Object)treePath.getLastPathComponent());
            return explorerTreeNode.getRDFSClass();
        }
        return null;
    }

    protected ExistentialTreeNode getSelectedNode() {
        JTree jTree = this.getTree();
        TreePath treePath = jTree.getSelectionPath();
        if (treePath != null) {
            return (ExistentialTreeNode)((Object)treePath.getLastPathComponent());
        }
        return null;
    }

    public OWLClass getSelectedParentClass() {
        TreePath treePath;
        int n;
        JTree jTree = this.getTree();
        if (jTree.getSelectionCount() == 1 && (n = (treePath = jTree.getSelectionPath()).getPathCount()) > 2) {
            ExistentialTreeNode existentialTreeNode = (ExistentialTreeNode)((Object)treePath.getPathComponent(n - 2));
            return existentialTreeNode.getOWLClass();
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    protected JTree getTree() {
        return (JTree)this.getSelectable();
    }

    public String getType() {
        return "Superclass Explorer";
    }

    public boolean isDefaultSynchronized() {
        return false;
    }

    public void navigateToResource(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSClass) {
            this.setSelectedClass((RDFSClass)rDFResource);
        }
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setDisplayParent(RDFSClass rDFSClass) {
        TooltippedSelectableTree tooltippedSelectableTree = this.tree;
        this.mainPanel.removeAll();
        ComponentUtilities.dispose((Component)((Object)tooltippedSelectableTree));
        this.tree = this.createTree();
        this.mainPanel.add("Center", new JScrollPane((Component)((Object)this.tree)));
    }

    public void setFinderComponent(JComponent jComponent) {
        this.add(jComponent, "South");
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)defaultRenderer);
    }

    public void setRoot(RDFSClass rDFSClass) {
        this.root = rDFSClass;
        LazyTreeNode lazyTreeNode = (LazyTreeNode)this.tree.getModel().getRoot();
        lazyTreeNode.reload(Collections.singleton(this.root));
    }

    public void setSelectedClass(RDFSClass rDFSClass) {
    }

    public String toString() {
        return "ExplorerTreePanel";
    }

    protected void updateActions() {
    }
}

