/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer;

import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerTreeNodeFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public abstract class ExplorerTreeNode
extends LazyTreeNode {
    protected ExplorerFilter filter;
    private ClassListener listener = new ClassAdapter(){

        public void superclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            ExplorerTreeNode.this.updateChildren();
        }

        public void superclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            ExplorerTreeNode.this.updateChildren();
        }
    };

    public ExplorerTreeNode(LazyTreeNode lazyTreeNode, RDFSClass rDFSClass, ExplorerFilter explorerFilter) {
        super(lazyTreeNode, (Object)rDFSClass);
        rDFSClass.addClassListener(this.listener);
        this.filter = explorerFilter;
    }

    protected abstract List createChildObjects();

    protected LazyTreeNode createNode(Object object) {
        return ExplorerTreeNodeFactory.create(this, (RDFSClass)object, this.filter);
    }

    private void deleteChildren() {
        super.dispose();
    }

    public void dispose() {
        this.getRDFSClass().removeClassListener(this.listener);
        this.deleteChildren();
    }

    protected Collection getChildObjects() {
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
        for (RDFSClass rDFSClass : this.createChildObjects()) {
            if (!this.filter.isValidChild(this.getRDFSClass(), rDFSClass)) continue;
            arrayList.add(rDFSClass);
        }
        return arrayList;
    }

    protected int getChildObjectCount() {
        return this.getChildObjects().size();
    }

    public ExplorerTreeNode getChildNode(int n) {
        return (ExplorerTreeNode)((Object)this.getChildAt(n));
    }

    protected Comparator getComparator() {
        return null;
    }

    public RDFSClass getRDFSClass() {
        return (RDFSClass)this.getUserObject();
    }

    public String toString(boolean bl) {
        return this.getRDFSClass().getBrowserText();
    }

    private void updateChildren() {
        this.reload();
    }
}

