/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.HashSet;
import java.util.Set;

public class ExistentialFillerProvider
extends OWLModelVisitorAdapter {
    private Set fillers = new HashSet();
    private Set visitedResources = new HashSet();
    private Set properties = new HashSet();

    public ExistentialFillerProvider(OWLObjectProperty oWLObjectProperty) {
        this.properties.add(oWLObjectProperty);
        this.properties.addAll(oWLObjectProperty.getSubproperties(true));
    }

    public void reset() {
        this.fillers.clear();
        this.visitedResources.clear();
    }

    public Set getFillers() {
        return this.fillers;
    }

    public void visitOWLNamedClass(OWLNamedClass oWLNamedClass) {
        if (this.visitedResources.contains(oWLNamedClass)) {
            return;
        }
        this.visitedResources.add(oWLNamedClass);
        for (Object e : oWLNamedClass.getSuperclasses(false)) {
            if (!(e instanceof OWLClass)) continue;
            ((OWLClass)e).accept(this);
        }
        for (Object e : oWLNamedClass.getEquivalentClasses()) {
            if (!(e instanceof OWLClass)) continue;
            ((OWLClass)e).accept(this);
        }
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass oWLIntersectionClass) {
        for (RDFSClass rDFSClass : oWLIntersectionClass.getOperands()) {
            if (!(rDFSClass instanceof OWLClass)) continue;
            ((OWLClass)rDFSClass).accept(this);
        }
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom oWLSomeValuesFrom) {
        if (this.properties.contains(oWLSomeValuesFrom.getOnProperty())) {
            this.processFiller((OWLObjectProperty)oWLSomeValuesFrom.getOnProperty(), (OWLClass)oWLSomeValuesFrom.getFiller());
        }
    }

    public void visitOWLMinCardinality(OWLMinCardinality oWLMinCardinality) {
        this.processCardinality(oWLMinCardinality);
    }

    public void visitOWLCardinality(OWLCardinality oWLCardinality) {
        this.processCardinality(oWLCardinality);
    }

    private void processCardinality(OWLCardinalityBase oWLCardinalityBase) {
        if (oWLCardinalityBase.getCardinality() > 0 && this.properties.contains(oWLCardinalityBase.getOnProperty()) && oWLCardinalityBase.getValuesFrom() != null && oWLCardinalityBase.getValuesFrom() instanceof OWLClass) {
            this.processFiller((OWLObjectProperty)oWLCardinalityBase.getOnProperty(), (OWLClass)oWLCardinalityBase.getValuesFrom());
        }
    }

    private void processFiller(OWLObjectProperty oWLObjectProperty, OWLClass oWLClass) {
        if (oWLClass instanceof OWLIntersectionClass) {
            OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)oWLClass;
            for (RDFSClass rDFSClass : oWLIntersectionClass.getOperands()) {
                if (!(rDFSClass instanceof OWLClass)) continue;
                OWLClass oWLClass2 = (OWLClass)rDFSClass;
                this.fillers.add(oWLClass2);
                if (!oWLObjectProperty.isTransitive()) continue;
                oWLClass2.accept(this);
            }
        } else {
            this.fillers.add(oWLClass);
            if (oWLObjectProperty.isTransitive()) {
                oWLClass.accept(this);
            }
        }
    }
}

