/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.editors;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.editors.DateValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JFormattedTextField;

public class TimeValueEditor
implements PropertyValueEditor {
    public boolean canEdit(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return DateValueEditor.canEdit(rDFResource.getOWLModel().getXSDtime(), rDFResource, rDFProperty, object);
    }

    public Object createDefaultValue(RDFResource rDFResource, RDFProperty rDFProperty) {
        OWLModel oWLModel = rDFProperty.getOWLModel();
        String string = XMLSchemaDatatypes.getTimeString(new Date());
        return this.createRDFSLiteral(oWLModel, string);
    }

    private RDFSLiteral createRDFSLiteral(OWLModel oWLModel, String string) {
        return oWLModel.createRDFSLiteral(string, oWLModel.getRDFSDatatypeByURI(XSDDatatype.XSDtime.getURI()));
    }

    public Object editValue(Component component, RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        final JFormattedTextField jFormattedTextField = new JFormattedTextField(simpleDateFormat);
        try {
            Date date = simpleDateFormat.parse(object.toString());
            jFormattedTextField.setValue(date);
            String string = rDFProperty.getBrowserText();
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            LabeledComponent labeledComponent = new LabeledComponent(string, (Component)jFormattedTextField);
            int n = ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(rDFProperty.getProject()), (Component)labeledComponent, "Edit " + rDFProperty.getBrowserText(), 11, new ModalDialogFactory.CloseCallback(){

                public boolean canClose(int n) {
                    return jFormattedTextField.isEditValid();
                }
            });
            if (n == 1) {
                Date date2 = (Date)jFormattedTextField.getValue();
                String string2 = XMLSchemaDatatypes.getTimeString(date2);
                return this.createRDFSLiteral(rDFProperty.getOWLModel(), string2);
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
        return null;
    }

    public boolean mustEdit(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return this.canEdit(rDFResource, rDFProperty, object);
    }
}

