/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.editors;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.toedter.calendar.JCalendar;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetUtil;
import java.awt.Component;
import java.util.Date;

public class DateValueEditor
implements PropertyValueEditor {
    public boolean canEdit(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        RDFSDatatype rDFSDatatype = rDFResource.getOWLModel().getXSDdate();
        return DateValueEditor.canEdit(rDFSDatatype, rDFResource, rDFProperty, object);
    }

    static boolean canEdit(RDFSDatatype rDFSDatatype, RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        Object object2;
        if (object instanceof RDFSLiteral && rDFSDatatype.equals((object2 = (RDFSLiteral)object).getDatatype())) {
            return true;
        }
        for (RDFSClass rDFSClass : rDFResource.getRDFTypes()) {
            if (!(rDFSClass instanceof RDFSNamedClass) || !OWLWidgetUtil.isDatatypeProperty(rDFSDatatype, (RDFSNamedClass)rDFSClass, rDFProperty)) continue;
            return true;
        }
        return false;
    }

    public Object createDefaultValue(RDFResource rDFResource, RDFProperty rDFProperty) {
        String string = XMLSchemaDatatypes.getDefaultDateValue();
        return this.createRDFSLiteral(rDFProperty.getOWLModel(), string);
    }

    private RDFSLiteral createRDFSLiteral(OWLModel oWLModel, String string) {
        return oWLModel.createRDFSLiteral(string, oWLModel.getRDFSDatatypeByURI(XSDDatatype.XSDdate.getURI()));
    }

    public Object editValue(Component component, RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        if (this.canEdit(rDFResource, rDFProperty, object)) {
            JCalendar jCalendar = new JCalendar(OWLDateWidget.getDate(object.toString()));
            String string = rDFProperty.getBrowserText();
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            LabeledComponent labeledComponent = new LabeledComponent(string, (Component)jCalendar);
            int n = ProtegeUI.getModalDialogFactory().showDialog(component, (Component)labeledComponent, "Edit " + rDFProperty.getBrowserText(), 11);
            if (n == 1) {
                Date date = jCalendar.getDate();
                String string2 = XMLSchemaDatatypes.getDateString(date);
                return this.createRDFSLiteral(rDFProperty.getOWLModel(), string2);
            }
        }
        return null;
    }

    public boolean mustEdit(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return this.canEdit(rDFResource, rDFProperty, object);
    }
}

