/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.ui.Finder;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.ui.SelectInstancesPanel;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class SelectResourcesPanel
extends SelectInstancesPanel {
    private static final String DIRECT_ASSERTED = "Direct Asserted Instances";
    private static final String DIRECT_INFERRED = "Direct Inferred Instances";
    private static final String ALL_ASSERTED = "All Asserted Instances";
    private static final String CLASS_HIERARCHY = "Class Hierarchy";
    private static final String ALL_INFERRED = "All Inferred Instances";
    private JComboBox instancesComboBox;
    private JTree _clsHierarchyTree;
    private LabeledComponent instanceLabelComponent;
    private Finder _instanceFinder;

    public SelectResourcesPanel(OWLModel oWLModel, Collection collection) {
        this(oWLModel, collection, false);
    }

    public SelectResourcesPanel(OWLModel oWLModel, Collection collection, boolean bl) {
        super((KnowledgeBase)oWLModel, collection);
        if (!bl) {
            this._instanceList.setSelectionMode(0);
        }
    }

    protected LabeledComponent createClsesLabeledComponent(KnowledgeBase knowledgeBase, Collection collection) {
        LabeledComponent labeledComponent = super.createClsesLabeledComponent(knowledgeBase, collection);
        return labeledComponent;
    }

    protected JComboBox createDirectAllInstanceComboBox() {
        super.createDirectAllInstanceComboBox();
        this.instancesComboBox = ComponentFactory.createComboBox();
        this.instancesComboBox.addItem(DIRECT_ASSERTED);
        this.instancesComboBox.addItem(DIRECT_INFERRED);
        this.instancesComboBox.addItem(ALL_ASSERTED);
        this.instancesComboBox.addItem(ALL_INFERRED);
        this.instancesComboBox.addItem(CLASS_HIERARCHY);
        this.instancesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectResourcesPanel.this.loadInstances();
            }
        });
        return this.instancesComboBox;
    }

    protected JComponent createClassHierarchyTree() {
        ParentChildRoot parentChildRoot = new ParentChildRoot((Collection)Collections.EMPTY_LIST);
        this._clsHierarchyTree = ComponentFactory.createSelectableTree(null, (LazyTreeRoot)parentChildRoot);
        this._clsHierarchyTree.setRootVisible(false);
        this._clsHierarchyTree.setShowsRootHandles(false);
        FrameRenderer frameRenderer = FrameRenderer.createInstance();
        frameRenderer.setDisplayDirectInstanceCount(false);
        this._clsHierarchyTree.setCellRenderer((TreeCellRenderer)frameRenderer);
        return this._clsHierarchyTree;
    }

    protected LabeledComponent createInstanceLabeledComponent() {
        this.instanceLabelComponent = this.createOWLIndividualsLabledComponent();
        this.createClassHierarchyTree();
        this._instanceFinder = (Finder)this.instanceLabelComponent.getFooterComponent();
        return this.instanceLabelComponent;
    }

    protected LabeledComponent createOWLIndividualsLabledComponent() {
        return super.createInstanceLabeledComponent();
    }

    protected Collection getInstances(Cls cls) {
        Object object = this.instancesComboBox.getSelectedItem();
        boolean bl = CLASS_HIERARCHY.equals(object);
        JScrollPane jScrollPane = (JScrollPane)this.instanceLabelComponent.getCenterComponent();
        if (bl && jScrollPane.getViewport().getView() != this._clsHierarchyTree) {
            jScrollPane.setViewportView(this._clsHierarchyTree);
            this._instanceFinder.setEnabled(false);
        } else if (!bl && jScrollPane.getViewport().getView() != this._instanceList) {
            jScrollPane.setViewportView(this._instanceList);
            this._instanceFinder.setEnabled(true);
        }
        if (DIRECT_INFERRED.equals(object)) {
            if (cls instanceof RDFSClass) {
                RDFSClass rDFSClass = (RDFSClass)cls;
                return rDFSClass.getInferredInstances(false);
            }
        } else {
            if (ALL_ASSERTED.equals(object)) {
                return this.getInstances(cls, false);
            }
            if (ALL_INFERRED.equals(object)) {
                if (cls instanceof RDFSClass) {
                    RDFSClass rDFSClass = (RDFSClass)cls;
                    return rDFSClass.getInferredInstances(true);
                }
            } else if (CLASS_HIERARCHY.equals(object)) {
                ParentChildRoot parentChildRoot = new ParentChildRoot(cls);
                ((SelectableTree)this._clsHierarchyTree).setRoot((LazyTreeRoot)parentChildRoot);
                this._clsHierarchyTree.setSelectionInterval(0, 0);
                return Collections.EMPTY_LIST;
            }
        }
        return this.getInstances(cls, true);
    }

    protected Collection getInstances(Cls cls, boolean bl) {
        return bl ? cls.getDirectInstances() : cls.getInstances();
    }

    public Collection getSelection() {
        Object object = this.instancesComboBox.getSelectedItem();
        if (CLASS_HIERARCHY.equals(object)) {
            return ComponentUtilities.getSelection((JTree)this._clsHierarchyTree);
        }
        return this.getInstanceSelection();
    }

    protected Collection getInstanceSelection() {
        return super.getSelection();
    }
}

