/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Validatable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreeRoot;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeCellRenderer;

public class SelectOWLClsesPanel
extends JComponent
implements Validatable {
    private static final long serialVersionUID = -1715739135005096261L;
    protected ClassTree _tree;
    private boolean _allowsMultiple;
    protected OWLModel _owlModel;

    public SelectOWLClsesPanel(OWLModel oWLModel) {
        this(oWLModel, Collections.EMPTY_SET);
    }

    public SelectOWLClsesPanel(OWLModel oWLModel, DefaultRenderer defaultRenderer) {
        this(oWLModel, Collections.EMPTY_SET);
        this._tree.setCellRenderer((TreeCellRenderer)defaultRenderer);
    }

    public SelectOWLClsesPanel(OWLModel oWLModel, Collection collection) {
        this(oWLModel, collection, true);
    }

    public SelectOWLClsesPanel(OWLModel oWLModel, Collection collection, boolean bl) {
        this._owlModel = oWLModel;
        this._allowsMultiple = bl;
        if (collection.isEmpty()) {
            collection = CollectionUtilities.createCollection((Object)oWLModel.getOWLThingClass());
        }
        ClassTreeRoot classTreeRoot = new ClassTreeRoot(collection, OWLUI.getSortClassTreeOption());
        this._tree = new ClassTree(null, classTreeRoot);
        this._tree.setCellRenderer((TreeCellRenderer)((Object)new ResourceRenderer(false)));
        int n = this._tree.getRowCount();
        int n2 = n - collection.size();
        for (int i = n - 1; i > n2; --i) {
            this._tree.expandRow(i);
        }
        this._tree.setSelectionRow(0);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)((Object)this._tree)), "Center");
        FindInDialogAction findInDialogAction = new FindInDialogAction(new DefaultClassFind(this._owlModel, 1), Icons.getFindClsIcon(), this._tree, true);
        ResourceFinder resourceFinder = new ResourceFinder(findInDialogAction);
        this.add((Component)resourceFinder, "South");
        this.setPreferredSize(new Dimension(300, 300));
    }

    public Collection getSelection() {
        return this._tree.getSelection();
    }

    public boolean validateContents() {
        boolean bl;
        boolean bl2 = bl = this._allowsMultiple || this.getSelection().size() <= 1;
        if (!bl) {
            ModalDialog.showMessageDialog((Component)this, (String)"Only 1 class can be selected", (int)14);
        }
        return bl;
    }

    public void saveContents() {
    }
}

