/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ListFinder;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SelectInstanceFromCollectionPanelWithFinder
extends JComponent {
    private JList _list;
    private Icon _clsIcon;

    public SelectInstanceFromCollectionPanelWithFinder(Collection collection, int n) {
        this.setLayout(new BorderLayout());
        this._list = ComponentFactory.createList((Action)ModalDialog.getCloseAction(this));
        collection = SelectInstanceFromCollectionPanelWithFinder.removeHidden(collection);
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList);
        this._list.setListData(arrayList.toArray());
        this.configureRenderer();
        if (n >= 0) {
            this.setSelection(n);
        }
        this.add((Component)new JScrollPane(this._list), "Center");
        this.add((Component)new ListFinder(this._list, "Find"), "South");
        this.setPreferredSize(new Dimension(300, 150));
    }

    private boolean isMultiUserClient() {
        Object e;
        boolean bl = false;
        if (this._list.getModel().getSize() > 0 && (e = this._list.getModel().getElementAt(0)) instanceof Frame) {
            Frame frame = (Frame)e;
            Project project = frame.getProject();
            bl = project.isMultiUserClient();
        }
        return bl;
    }

    private void configureRenderer() {
        FrameRenderer frameRenderer;
        if (this.isMultiUserClient()) {
            frameRenderer = new FrameRenderer(){

                protected Icon getIcon(Cls cls) {
                    Icon icon;
                    if (SelectInstanceFromCollectionPanelWithFinder.this._clsIcon == null) {
                        icon = cls.getIcon();
                        if (!cls.isMetaCls()) {
                            SelectInstanceFromCollectionPanelWithFinder.this._clsIcon = icon;
                        }
                    } else {
                        icon = SelectInstanceFromCollectionPanelWithFinder.this._clsIcon;
                    }
                    return icon;
                }
            };
        } else {
            frameRenderer = FrameRenderer.createInstance();
            frameRenderer.setDisplayTrailingIcons(false);
        }
        this._list.setCellRenderer(frameRenderer);
    }

    public Instance getSelection() {
        return (Instance)this._list.getSelectedValue();
    }

    private static Collection removeHidden(Collection arrayList) {
        ArrayList<Instance> arrayList2;
        Project project = ((Instance)CollectionUtilities.getFirstItem((Collection)arrayList)).getProject();
        if (project.getDisplayHiddenClasses()) {
            arrayList2 = arrayList;
        } else {
            arrayList2 = new ArrayList<Instance>();
            for (Instance instance : arrayList) {
                if (!instance.isVisible()) continue;
                arrayList2.add(instance);
            }
        }
        return arrayList2;
    }

    private void setSelection(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectInstanceFromCollectionPanelWithFinder.this._list.setSelectedIndex(n);
                SelectInstanceFromCollectionPanelWithFinder.this._list.ensureIndexIsVisible(n);
            }
        });
    }
}

