/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.MessagePanel;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.Validatable;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class ModalDialog
extends JDialog
implements Disposable {
    public static final int OPTION_OK = 1;
    public static final int OPTION_YES = 2;
    public static final int OPTION_NO = 3;
    public static final int OPTION_CANCEL = 4;
    public static final int OPTION_CLOSE = 5;
    public static final int RESULT_ERROR = 6;
    public static final int MODE_OK_CANCEL = 11;
    public static final int MODE_YES_NO_CANCEL = 12;
    public static final int MODE_YES_NO = 13;
    public static final int MODE_CLOSE = 14;
    private int _result;
    private Component _panel;
    private JPanel _buttonsPanel;
    private ModalDialogFactory.CloseCallback _closeCallback;
    private boolean _enableCloseButton;
    private static ModalDialog _currentDialog;

    private ModalDialog(Dialog dialog, Component component, String string, int n, ModalDialogFactory.CloseCallback closeCallback, boolean bl, Component component2) {
        super(dialog, string, true);
        this.init(component, n, closeCallback, bl, component2);
    }

    private ModalDialog(Frame frame, Component component, String string, int n, ModalDialogFactory.CloseCallback closeCallback, boolean bl, Component component2) {
        super(frame, string, true);
        this.init(component, n, closeCallback, bl, component2);
    }

    public static void attemptDialogClose(int n) {
        ModalDialog modalDialog = ModalDialog.getCurrentDialog();
        if (modalDialog != null) {
            modalDialog.attemptClose(n);
        }
    }

    public void attemptClose(int n) {
        Validatable validatable;
        boolean bl = this._closeCallback == null ? true : this._closeCallback.canClose(n);
        if (bl && n == 1 && this._panel instanceof Validatable && (bl = (validatable = (Validatable)this._panel).validateContents())) {
            validatable.saveContents();
        }
        if (bl) {
            this._result = n;
            this.close();
        }
    }

    private void close() {
        ComponentUtilities.dispose((Component)this);
        _currentDialog = null;
    }

    private JButton createButton(final int n, ResourceKey resourceKey) {
        StandardAction standardAction = new StandardAction(resourceKey){

            public void actionPerformed(ActionEvent actionEvent) {
                ModalDialog.this.attemptClose(n);
            }
        };
        JButton jButton = ComponentFactory.createButton((Action)standardAction);
        jButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        ModalDialog.this.attemptClose(n);
                        break;
                    }
                    case 27: {
                        ModalDialog.this.attemptClose(4);
                        break;
                    }
                }
            }
        });
        return jButton;
    }

    private JPanel createButtonsPanel(int n) {
        JPanel jPanel = ComponentFactory.createPanel();
        jPanel.setLayout(new GridLayout(1, 3, 10, 10));
        switch (n) {
            case 11: {
                jPanel.add(this.createButton(1, ResourceKey.OK_BUTTON_LABEL));
                jPanel.add(this.createButton(4, ResourceKey.CANCEL_BUTTON_LABEL));
                break;
            }
            case 13: {
                jPanel.add(this.createButton(2, ResourceKey.YES_BUTTON_LABEL));
                jPanel.add(this.createButton(3, ResourceKey.NO_BUTTON_LABEL));
                break;
            }
            case 12: {
                jPanel.add(this.createButton(2, ResourceKey.YES_BUTTON_LABEL));
                jPanel.add(this.createButton(3, ResourceKey.NO_BUTTON_LABEL));
                jPanel.add(this.createButton(4, ResourceKey.CANCEL_BUTTON_LABEL));
                break;
            }
            case 14: {
                jPanel.add(this.createButton(5, ResourceKey.CLOSE_BUTTON_LABEL));
                break;
            }
        }
        JPanel jPanel2 = ComponentFactory.createPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    public static ModalDialog getCurrentDialog() {
        return _currentDialog;
    }

    private void getFocus(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.requestFocusInWindow();
            }
        });
    }

    private void getFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JButton jButton = (JButton)((Container)ModalDialog.this._buttonsPanel.getComponent(0)).getComponent(0);
                jButton.requestFocusInWindow();
            }
        });
    }

    private void init(Component component, int n, ModalDialogFactory.CloseCallback closeCallback, boolean bl, Component component2) {
        _currentDialog = this;
        this._closeCallback = closeCallback;
        this._enableCloseButton = bl;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowCloseListener());
        switch (n) {
            case 11: {
                this._result = 4;
                break;
            }
            case 12: {
                this._result = 4;
                break;
            }
            case 14: {
                this._result = 5;
                break;
            }
        }
        this._panel = component;
        this._buttonsPanel = this.createButtonsPanel(n);
        this.layoutWidgets();
        this.pack();
        ComponentUtilities.center((Component)this);
        if (component2 == null) {
            this.getFocus();
        } else {
            this.getFocus(component2);
        }
        this.setVisible(true);
    }

    private void layoutWidgets() {
        JPanel jPanel = ComponentFactory.createPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(this._panel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this._buttonsPanel, "South");
    }

    public static int showDialog(Component component, Component component2, String string, int n) {
        return ModalDialog.showDialog(component, component2, string, n, null);
    }

    public static int showDialog(Component component, Component component2, String string, int n, ModalDialogFactory.CloseCallback closeCallback) {
        return ModalDialog.showDialog(component, component2, string, n, closeCallback, true);
    }

    public static int showDialog(Component component, Component component2, String string, int n, ModalDialogFactory.CloseCallback closeCallback, boolean bl) {
        return ModalDialog.showDialog(component, component2, string, n, closeCallback, bl, null);
    }

    public static int showDialog(Component component, Component component2, String string, int n, ModalDialogFactory.CloseCallback closeCallback, boolean bl, Component component3) {
        Window window = component == null || component instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component);
        ModalDialog modalDialog = window instanceof Frame || window == null ? new ModalDialog((Frame)window, component2, string, n, closeCallback, bl, component3) : new ModalDialog((Dialog)window, component2, string, n, closeCallback, bl, component3);
        int n2 = modalDialog == null ? 6 : modalDialog._result;
        return n2;
    }

    public static void showMessageDialog(Component component, String string) {
        ModalDialog.showMessageDialog(component, string, 14);
    }

    public static void showMessageDialog(Component component, String string, String string2) {
        ModalDialog.showMessageDialog(component, string, string2, 14);
    }

    public static int showMessageDialog(Component component, String string, int n) {
        return ModalDialog.showDialog(component, (Component)new MessagePanel(string), "", n);
    }

    public static int showMessageDialog(Component component, String string, String string2, int n) {
        return ModalDialog.showDialog(component, (Component)new MessagePanel(string), string2, n);
    }

    public static Action getCloseAction(final Component component) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component2 = SwingUtilities.getRoot(component);
                if (component2 instanceof ModalDialog) {
                    ModalDialog modalDialog = (ModalDialog)component2;
                    modalDialog.attemptClose(1);
                }
            }
        };
    }

    private class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            int n;
            int n2 = 4;
            if (!ModalDialog.this._enableCloseButton && (n = ModalDialog.showMessageDialog((Component)ModalDialog.this, LocalizedText.getText((ResourceKey)ResourceKey.DIALOG_SAVE_CHANGES_TEXT), 13)) == 2) {
                n2 = 1;
            }
            ModalDialog.this.attemptClose(n2);
        }
    }
}

