/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.dialogs.AbstractSelectionDialogFactory;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.dialogs.SelectInstanceFromCollectionPanelWithFinder;
import edu.stanford.smi.protegex.owl.ui.dialogs.SelectOWLClsesPanel;
import edu.stanford.smi.protegex.owl.ui.dialogs.SelectResourcesFromCollectionPanel;
import edu.stanford.smi.protegex.owl.ui.dialogs.SelectResourcesPanel;
import edu.stanford.smi.protegex.owl.ui.dialogs.SelectResourcesWithBrowserTextPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultSelectionDialogFactory
extends AbstractSelectionDialogFactory {
    private static Collection getFirstTwoClasses(OWLModel oWLModel, Collection set) {
        HashSet hashSet = new HashSet();
        if (set.isEmpty()) {
            set = Collections.singleton(oWLModel.getOWLThingClass());
        }
        DefaultSelectionDialogFactory.getFirstTwoClasses(set, hashSet);
        return hashSet;
    }

    private static void getFirstTwoClasses(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && collection2.size() != 2) {
            Cls cls = (Cls)iterator.next();
            collection2.add(cls);
            if (collection2.size() == 2) break;
            DefaultSelectionDialogFactory.getFirstTwoClasses(cls.getDirectSubclasses(), collection2);
        }
    }

    private static boolean hasOneClass(Collection collection) {
        Cls cls;
        boolean bl = collection.size() == 1 ? (cls = (Cls)CollectionUtilities.getFirstItem((Collection)collection)).getDirectSubclassCount() == 0 : false;
        return bl;
    }

    private static Collection pickClasses(Component component, OWLModel oWLModel, Collection collection, String string, boolean bl) {
        Collection collection2;
        boolean bl2 = true;
        if (collection.isEmpty()) {
            collection2 = Collections.EMPTY_LIST;
        } else if (DefaultSelectionDialogFactory.hasOneClass(collection)) {
            collection2 = collection;
        } else {
            SelectOWLClsesPanel selectOWLClsesPanel = new SelectOWLClsesPanel(oWLModel, collection);
            int n = ProtegeUI.getModalDialogFactory().showDialog(component, selectOWLClsesPanel, string, 11);
            collection2 = n == 1 ? selectOWLClsesPanel.getSelection() : Collections.EMPTY_LIST;
        }
        return collection2;
    }

    private static Cls pickClass(Component component, OWLModel oWLModel, Collection collection, String string) {
        Cls cls;
        Collection collection2 = DefaultSelectionDialogFactory.getFirstTwoClasses(oWLModel, collection);
        switch (collection2.size()) {
            case 0: {
                ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "There are no allowed classes");
                cls = null;
                break;
            }
            case 1: {
                cls = (Cls)CollectionUtilities.getFirstItem((Collection)collection2);
                break;
            }
            case 2: {
                cls = DefaultSelectionDialogFactory.promptForClass(component, oWLModel, collection, string);
                break;
            }
            default: {
                Assert.fail((String)("bad size: " + collection2.size()));
                cls = null;
            }
        }
        return cls;
    }

    private static RDFSDatatype pickDatatype(Component component, OWLModel oWLModel) {
        Object var2_2 = null;
        Collection<RDFSDatatype> collection = oWLModel.getRDFSDatatypes();
        return (RDFSDatatype)ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(component, oWLModel, collection, "Select the XML Schema datatype to insert");
    }

    private static Instance pickInstanceFromCollection(Component component, Collection collection, int n, String string) {
        Instance instance = null;
        if (collection != null && collection.size() > 0) {
            Collection collection2 = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection, true);
            SelectInstanceFromCollectionPanelWithFinder selectInstanceFromCollectionPanelWithFinder = new SelectInstanceFromCollectionPanelWithFinder(collection, n);
            int n2 = ProtegeUI.getModalDialogFactory().showDialog(component, selectInstanceFromCollectionPanelWithFinder, string, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection2, false);
            if (n2 == 1) {
                instance = selectInstanceFromCollectionPanelWithFinder.getSelection();
            }
        }
        return instance;
    }

    private static Collection pickInstancesFromCollection(Component component, Collection collection, String string) {
        List list = Collections.EMPTY_LIST;
        if (collection != null && collection.size() > 0) {
            Collection collection2 = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection, true);
            SelectResourcesFromCollectionPanel selectResourcesFromCollectionPanel = new SelectResourcesFromCollectionPanel(collection);
            int n = ProtegeUI.getModalDialogFactory().showDialog(component, selectResourcesFromCollectionPanel, string, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection2, false);
            switch (n) {
                case 1: {
                    return selectResourcesFromCollectionPanel.getSelection();
                }
                case 4: {
                    break;
                }
                default: {
                    Assert.fail((String)("bad result: " + n));
                }
            }
        }
        return list;
    }

    private static RDFSNamedClass promptForClass(final Component component, OWLModel oWLModel, Collection collection, final String string) {
        Object object;
        final SelectOWLClsesPanel selectOWLClsesPanel = new SelectOWLClsesPanel(oWLModel, collection);
        ModalDialogFactory.CloseCallback closeCallback = new ModalDialogFactory.CloseCallback(){

            public boolean canClose(int n) {
                boolean bl;
                if (n == 1) {
                    Cls cls = (Cls)CollectionUtilities.getFirstItem((Collection)selectOWLClsesPanel.getSelection());
                    boolean bl2 = bl = cls != null;
                    if (!bl) {
                        ProtegeUI.getModalDialogFactory().showMessageDialog(component, string, "Information");
                    }
                } else {
                    bl = true;
                }
                return bl;
            }
        };
        int n = ProtegeUI.getModalDialogFactory().showDialog(component, (Component)selectOWLClsesPanel, string, 11, closeCallback);
        if (n == 1 && (object = CollectionUtilities.getFirstItem((Collection)selectOWLClsesPanel.getSelection())) instanceof RDFSNamedClass) {
            return (RDFSNamedClass)object;
        }
        return null;
    }

    public RDFSNamedClass selectClass(Component component, OWLModel oWLModel, Collection collection, String string) {
        Cls cls;
        if (component == null) {
            component = ProtegeUI.getProjectView(oWLModel.getProject());
        }
        if ((cls = DefaultSelectionDialogFactory.pickClass(component, oWLModel, collection, string)) instanceof RDFSNamedClass) {
            return (RDFSNamedClass)cls;
        }
        return null;
    }

    public RDFSDatatype selectDatatype(Component component, OWLModel oWLModel) {
        if (component == null) {
            component = ProtegeUI.getProjectView(oWLModel.getProject());
        }
        return DefaultSelectionDialogFactory.pickDatatype(component, oWLModel);
    }

    public Set selectClasses(Component component, OWLModel oWLModel, Collection collection, String string) {
        if (component == null) {
            component = ProtegeUI.getProjectView(oWLModel.getProject());
        }
        return new HashSet(DefaultSelectionDialogFactory.pickClasses(component, oWLModel, collection, string, true));
    }

    public RDFProperty selectProperty(Component component, OWLModel oWLModel, Collection collection, String string) {
        if (component == null) {
            component = ProtegeUI.getProjectView(oWLModel.getProject());
        }
        return (RDFProperty)DefaultSelectionDialogFactory.pickInstanceFromCollection(component, collection, collection.isEmpty() ? -1 : 0, string);
    }

    public RDFResource selectResourceFromCollection(Component component, OWLModel oWLModel, Collection collection, String string) {
        if (component == null) {
            component = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
        }
        return (RDFResource)DefaultSelectionDialogFactory.pickInstanceFromCollection(component, collection, collection.isEmpty() ? -1 : 0, string);
    }

    public RDFResource selectResourceByType(Component component, OWLModel oWLModel, Collection collection, String string) {
        if (!collection.isEmpty()) {
            if (component == null) {
                component = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
            }
            Collection collection2 = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection, true);
            SelectResourcesPanel selectResourcesPanel = new SelectResourcesPanel(oWLModel, collection, true);
            int n = ProtegeUI.getModalDialogFactory().showDialog(component, (Component)((Object)selectResourcesPanel), string, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection2, false);
            if (n == 1) {
                Collection collection3 = selectResourcesPanel.getSelection();
                for (Instance instance : collection3) {
                    if (!(instance instanceof RDFResource)) continue;
                    return (RDFResource)instance;
                }
            }
        }
        return null;
    }

    public RDFResource selectResourceWithBrowserTextByType(Component component, OWLModel oWLModel, Collection collection, String string) {
        if (!collection.isEmpty()) {
            if (component == null) {
                component = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
            }
            Collection collection2 = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection, true);
            SelectResourcesWithBrowserTextPanel selectResourcesWithBrowserTextPanel = new SelectResourcesWithBrowserTextPanel(oWLModel, collection, true);
            int n = ProtegeUI.getModalDialogFactory().showDialog(component, (Component)((Object)selectResourcesWithBrowserTextPanel), string, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection2, false);
            if (n == 1) {
                Collection collection3 = selectResourcesWithBrowserTextPanel.getSelection();
                for (Instance instance : collection3) {
                    if (!(instance instanceof RDFResource)) continue;
                    return (RDFResource)instance;
                }
            }
        }
        return null;
    }

    public Set selectResourcesByType(Component component, OWLModel oWLModel, Collection collection, String string) {
        if (!collection.isEmpty()) {
            Collection collection2 = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection, true);
            if (component == null) {
                component = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
            }
            SelectResourcesPanel selectResourcesPanel = new SelectResourcesPanel(oWLModel, collection, true);
            int n = ProtegeUI.getModalDialogFactory().showDialog(component, (Component)((Object)selectResourcesPanel), string, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection2, false);
            if (n == 1) {
                Collection collection3 = selectResourcesPanel.getSelection();
                HashSet<Instance> hashSet = new HashSet<Instance>();
                for (Instance instance : collection3) {
                    if (!(instance instanceof RDFResource)) continue;
                    hashSet.add(instance);
                }
                return hashSet;
            }
        }
        return Collections.EMPTY_SET;
    }

    public Set selectResourcesWithBrowserTextByType(Component component, OWLModel oWLModel, Collection collection, String string) {
        if (!collection.isEmpty()) {
            Collection collection2 = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection, true);
            if (component == null) {
                component = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
            }
            SelectResourcesWithBrowserTextPanel selectResourcesWithBrowserTextPanel = new SelectResourcesWithBrowserTextPanel(oWLModel, collection, true);
            int n = ProtegeUI.getModalDialogFactory().showDialog(component, (Component)((Object)selectResourcesWithBrowserTextPanel), string, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection2, false);
            if (n == 1) {
                Collection collection3 = selectResourcesWithBrowserTextPanel.getSelection();
                HashSet<Instance> hashSet = new HashSet<Instance>();
                for (Instance instance : collection3) {
                    if (!(instance instanceof RDFResource)) continue;
                    hashSet.add(instance);
                }
                return hashSet;
            }
        }
        return Collections.EMPTY_SET;
    }

    public Set selectResourcesFromCollection(Component component, OWLModel oWLModel, Collection collection, String string) {
        if (component == null) {
            component = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
        }
        return new HashSet(DefaultSelectionDialogFactory.pickInstancesFromCollection(component, collection, string));
    }

    public static Collection ensureResourcesHaveVisibility(Collection collection, boolean bl) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        for (Instance instance : collection) {
            if (instance.isVisible() == bl) continue;
            instance.setVisible(bl);
            arrayList.add(instance);
        }
        return arrayList;
    }
}

