/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class PropertySuggestionPopup {
    private JList propertyList = new JList();
    private JWindow popupWindow;
    private ConditionsTable table;
    private JPopupMenu popupMenu;
    public static final int POPUP_WIDTH = 220;
    public static final String POPUP_TITLE = "Suggested properties";

    public PropertySuggestionPopup(Window window, ConditionsTable conditionsTable) {
        this.propertyList.setCellRenderer(new ResourceRenderer());
        this.propertyList.setRequestFocusEnabled(false);
        this.propertyList.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PropertySuggestionPopup.this.insertPropertyName();
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertySuggestionPopup.this.popupWindow.setVisible(false);
            }
        });
        this.popupWindow = new JWindow(window);
        this.popupWindow.setFocusableWindowState(false);
        this.popupWindow.setFocusable(false);
        final LabeledComponent labeledComponent = new LabeledComponent(POPUP_TITLE, new JScrollPane(this.propertyList));
        labeledComponent.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        labeledComponent.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    PropertySuggestionPopup.this.popupMenu.show((Component)labeledComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    PropertySuggestionPopup.this.popupMenu.show((Component)labeledComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.popupWindow.setContentPane((Container)labeledComponent);
        this.table = conditionsTable;
    }

    public void showPopup(OWLNamedClass oWLNamedClass) {
        Set set = oWLNamedClass.getAssociatedProperties();
        if (set.size() > 0) {
            this.propertyList.setListData(set.toArray());
            this.popupWindow.setSize(220, this.table.getParent().getHeight());
            Point point = this.table.getLocation();
            SwingUtilities.convertPointToScreen(point, (Component)((Object)this.table));
            this.popupWindow.setLocation(point.x - this.popupWindow.getWidth() - 10, point.y);
            this.popupWindow.setVisible(true);
        }
    }

    public void hidePopup() {
        this.popupWindow.setVisible(false);
    }

    protected void insertPropertyName() {
        RDFProperty rDFProperty = (RDFProperty)this.propertyList.getSelectedValue();
        if (rDFProperty != null) {
            JTextComponent jTextComponent = this.table.getSymbolEditorComponent().getTextComponent();
            try {
                jTextComponent.getDocument().insertString(jTextComponent.getCaretPosition(), rDFProperty.getBrowserText(), null);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
        }
    }
}

