/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public class ConditionsTableItem
implements ConditionsTableConstants,
Comparable {
    protected RDFSClass aClass;
    private OWLIntersectionClass definition;
    private boolean isNew;
    private OWLNamedClass originCls;
    private int type;
    public static final String INHERITED = "INHERITED ";
    public static final String NECESSARY = "NECESSARY ";
    public static final String SUFFICIENT = "NECESSARY & SUFFICIENT ";
    private List<RDFSNamedClass> owlRestrictionMetaClses = null;

    protected ConditionsTableItem(RDFSClass rDFSClass, int n, OWLNamedClass oWLNamedClass, OWLIntersectionClass oWLIntersectionClass, boolean bl) {
        this.aClass = rDFSClass;
        this.definition = oWLIntersectionClass;
        this.type = n;
        this.originCls = oWLNamedClass;
        this.isNew = bl;
    }

    public void dispose() {
        this.aClass = null;
        this.definition = null;
        this.originCls = null;
    }

    public int compareTo(Object object) {
        if (object instanceof ConditionsTableItem) {
            ConditionsTableItem conditionsTableItem = (ConditionsTableItem)object;
            if (this.type > conditionsTableItem.type) {
                return -1;
            }
            if (this.type < conditionsTableItem.type) {
                return 1;
            }
            if (conditionsTableItem.isSeparator()) {
                return 1;
            }
            if (this.isSeparator()) {
                return -1;
            }
            return this.compareToWithSameType(conditionsTableItem.aClass);
        }
        return 0;
    }

    int compareToWithSameType(RDFSClass rDFSClass) {
        if (this.aClass instanceof OWLNamedClass) {
            if (rDFSClass instanceof OWLNamedClass) {
                return this.aClass.compareTo(rDFSClass);
            }
            return -1;
        }
        if (rDFSClass instanceof OWLNamedClass) {
            return 1;
        }
        return this.compareToWithAnonymousClses((OWLAnonymousClass)rDFSClass);
    }

    private int compareToWithAnonymousClses(OWLAnonymousClass oWLAnonymousClass) {
        if (this.aClass instanceof OWLRestriction) {
            if (oWLAnonymousClass instanceof OWLRestriction) {
                return this.compareToWithRestrictions((OWLRestriction)oWLAnonymousClass);
            }
            return 1;
        }
        return this.aClass.compareTo(oWLAnonymousClass);
    }

    private int compareToWithRestrictions(OWLRestriction oWLRestriction) {
        RDFProperty rDFProperty;
        OWLRestriction oWLRestriction2 = (OWLRestriction)this.aClass;
        RDFProperty rDFProperty2 = oWLRestriction2.getOnProperty();
        if (rDFProperty2.equals(rDFProperty = oWLRestriction.getOnProperty())) {
            if (this.owlRestrictionMetaClses == null) {
                this.owlRestrictionMetaClses = Arrays.asList(this.aClass.getOWLModel().getOWLRestrictionMetaclasses());
            }
            int n = this.owlRestrictionMetaClses.indexOf(oWLRestriction2.getProtegeType());
            int n2 = this.owlRestrictionMetaClses.indexOf(oWLRestriction.getProtegeType());
            return new Integer(n).compareTo(new Integer(n2));
        }
        return rDFProperty2.compareTo(rDFProperty);
    }

    protected static ConditionsTableItem create(RDFSClass rDFSClass, int n) {
        return new ConditionsTableItem(rDFSClass, n, null, null, false);
    }

    protected static ConditionsTableItem createInherited(RDFSClass rDFSClass, OWLNamedClass oWLNamedClass) {
        return new ConditionsTableItem(rDFSClass, -2, oWLNamedClass, null, false);
    }

    protected static ConditionsTableItem createNew(int n) {
        return new ConditionsTableItem(null, n, null, null, true);
    }

    protected static ConditionsTableItem createSufficient(RDFSClass rDFSClass, int n, OWLIntersectionClass oWLIntersectionClass) {
        return new ConditionsTableItem(rDFSClass, n, null, oWLIntersectionClass, false);
    }

    protected static ConditionsTableItem createSeparator(int n) {
        return new ConditionsTableItem(null, n, null, null, false);
    }

    public RDFSClass getCls() {
        return this.aClass;
    }

    protected OWLIntersectionClass getDefinition() {
        return this.definition;
    }

    protected Icon getIcon(int n) {
        if (this.isSeparator()) {
            return null;
        }
        if (this.isDefinition()) {
            return null;
        }
        if (this.type == -2) {
            return OWLIcons.getImageIcon("SuperclassInherited");
        }
        if (this.type == -1) {
            return ConditionsTableItem.getSuperclassIcon();
        }
        return null;
    }

    public OWLNamedClass getOriginCls() {
        return this.originCls;
    }

    protected static Icon getSuperclassIcon() {
        return OWLIcons.getImageIcon("Superclass");
    }

    protected int getType() {
        return this.type;
    }

    protected boolean isDefinition() {
        return this.type >= 0;
    }

    protected boolean isInherited() {
        return this.type == -2;
    }

    protected boolean isNew() {
        return this.isNew;
    }

    protected boolean isSeparator() {
        return this.aClass == null && !this.isNew();
    }

    protected void setType(int n) {
        this.type = n;
    }

    public String toString() {
        if (this.isSeparator()) {
            if (this.isDefinition()) {
                return SUFFICIENT;
            }
            if (this.isInherited()) {
                return INHERITED;
            }
            return NECESSARY;
        }
        if (this.isInherited()) {
            return this.getDisplayText() + "    [" + this.originCls.getBrowserText() + "]";
        }
        if (this.isNew()) {
            return "";
        }
        return this.getDisplayText();
    }

    private String getDisplayText() {
        return this.aClass.getBrowserText();
    }
}

