/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionEditorComponent;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTextField;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableTransferHandler;
import edu.stanford.smi.protegex.owl.ui.conditions.PropertyConditionsDisplay;
import edu.stanford.smi.protegex.owl.ui.conditions.PropertySuggestionPopup;
import edu.stanford.smi.protegex.owl.ui.conditions.SeparatorCellRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.View;

public class ConditionsTable
extends OWLTable
implements ConditionsTableConstants,
PropertyConditionsDisplay {
    private SeparatorCellRenderer separatorCellRendererGrayed = new SeparatorCellRenderer(true);
    private ConditionsTableModel tableModel;
    private PropertySuggestionPopup propertyPopup;

    public ConditionsTable(OWLModel oWLModel, ConditionsTableModel conditionsTableModel) {
        super(conditionsTableModel, oWLModel, true);
        this.tableModel = conditionsTableModel;
        this.setTransferHandler(new ConditionsTableTransferHandler(oWLModel));
    }

    protected void addNavigationMenuItems(RDFResource rDFResource, JPopupMenu jPopupMenu) {
        super.addNavigationMenuItems(rDFResource, jPopupMenu);
        int n = this.getSelectedRow();
        if (this.tableModel.getType(n) == -2) {
            final OWLNamedClass oWLNamedClass = this.tableModel.getOriginClass(n);
            jPopupMenu.add(new AbstractAction("Navigate to defining class (" + oWLNamedClass.getBrowserText() + ")", ProtegeUI.getIcon(oWLNamedClass)){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConditionsTable.this.navigateTo(oWLNamedClass);
                }
            });
        }
    }

    public void addRestriction(OWLRestriction oWLRestriction) {
        this.addRow(oWLRestriction);
    }

    public int addRow(Cls cls) {
        if (cls.equals(this.tableModel.getEditedCls())) {
            this.tableModel.displaySemanticError("Cannot assign " + cls.getBrowserText() + " to itself.");
            return -1;
        }
        RDFSClass rDFSClass = (RDFSClass)cls;
        if (this.tableModel.addRow(rDFSClass, this.getSelectedRow())) {
            this.setSelectedRow(rDFSClass);
            return this.tableModel.getClassRow(rDFSClass);
        }
        this.tableModel.displaySemanticError("Could not add " + cls.getBrowserText() + ".");
        if (rDFSClass instanceof OWLAnonymousClass) {
            rDFSClass.delete();
        }
        return -1;
    }

    protected void showSymbolPanel(boolean bl) {
        super.showSymbolPanel(bl);
        this.showPropertyWindow();
    }

    protected void showPropertyWindow() {
        if (this.propertyPopup == null) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)((Object)this));
            this.propertyPopup = new PropertySuggestionPopup(window, this);
        }
        this.propertyPopup.showPopup(this.getEditedCls());
    }

    protected void hidePropertyWindow() {
        if (this.propertyPopup != null) {
            this.propertyPopup.hidePopup();
        }
    }

    public void createAndEditRow() {
        int n = this.getSelectedRow();
        this.createAndEditRow(n);
    }

    private void createAndEditRow(int n) {
        if (n >= 0 && this.tableModel.getType(n) != -2) {
            int n2 = this.tableModel.addEmptyRow(n);
            this.editExpression(n2);
        }
    }

    protected ResourceRenderer createOWLFrameRenderer() {
        return new ResourceRenderer(){
            private Icon icon;
            private Cls originCls;

            protected void loadCls(Cls cls) {
                int n = ConditionsTable.this.tableModel.getClassRow((RDFSClass)cls);
                this.originCls = null;
                boolean bl = false;
                if (cls instanceof OWLAnonymousClass && ConditionsTable.this.tableModel.getType(n) == -2) {
                    Icon icon = cls.getIcon();
                    if (icon instanceof ImageIcon) {
                        this.setMainIcon(OWLIcons.getInheritedClsIcon((ImageIcon)icon));
                    } else {
                        this.setMainIcon(icon);
                    }
                    super.loadClsAfterIcon(cls);
                    this.originCls = ConditionsTable.this.tableModel.getOriginClass(n);
                    bl = true;
                } else {
                    super.loadCls(cls);
                }
                this.icon = ConditionsTable.this.tableModel.getIcon(n, ConditionsTable.this.getRowHeight());
                this.setGrayedText(bl);
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                int n = this.getWidth();
                if (this.icon != null) {
                    int n2 = n - this.icon.getIconWidth() - 3;
                    this.icon.paintIcon((Component)((Object)this), graphics, n2, 1);
                    if (this.originCls != null) {
                        FontMetrics fontMetrics = this._fontMetrics;
                        int n3 = fontMetrics.stringWidth(this.getMainText());
                        int n4 = fontMetrics.getAscent();
                        String string = this.originCls.getBrowserText();
                        String string2 = "[from " + string + "]";
                        int n5 = fontMetrics.stringWidth(string2);
                        int n6 = string.length();
                        while (n6 > 3 && n2 - n5 - 2 <= n3 + 26) {
                            string2 = "[from " + string.substring(0, --n6) + "...]";
                            n5 = fontMetrics.stringWidth(string2);
                        }
                        if (n2 - n5 - 2 > n3 + 26) {
                            graphics.setColor(Color.gray);
                            graphics.drawString(string2, n2 - n5 - 2, n4);
                        }
                    }
                }
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                int n3 = component.getPreferredSize().height;
                if (jTable.getRowHeight(n) != n3) {
                    SymbolPanel symbolPanel = ConditionsTable.this.getSymbolPanel();
                    jTable.setRowHeight(n, n3);
                    symbolPanel.setLocation(symbolPanel.getX(), symbolPanel.getY() + n3);
                    symbolPanel.repaint();
                }
                return component;
            }
        };
    }

    protected int getPreferredRowHeight(JTable jTable, SymbolEditorComponent symbolEditorComponent) {
        View view = symbolEditorComponent.getTextComponent().getUI().getRootView(symbolEditorComponent.getTextComponent());
        view.setSize(jTable.getWidth(), 2.1474836E9f);
        return (int)view.getPreferredSpan(1);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = super.createPopupMenu();
        int n = this.getSelectedRow();
        if (n >= 0 && this.tableModel.isDefinition(n)) {
            JMenuItem jMenuItem = jPopupMenu.add(new AbstractAction("Create new necessary & sufficient block", Icons.getBlankIcon()){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ConditionsTable.this.tableModel.addEmptyDefinitionBlock();
                    ConditionsTable.this.setSelectedRow(n);
                }
            });
            jPopupMenu.add((Component)jMenuItem, 0);
            jPopupMenu.add((Component)new JPopupMenu.Separator(), 1);
        }
        return jPopupMenu;
    }

    protected SymbolTextField createSymbolTextField(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay) {
        return new ClassDescriptionTextField(oWLModel, symbolErrorDisplay);
    }

    protected SymbolEditorComponent createSymbolEditorComponent(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay) {
        return new ClassDescriptionEditorComponent(oWLModel, symbolErrorDisplay, true);
    }

    public void displayRowsWithProperty(OWLProperty oWLProperty) {
        this.getOWLFrameRenderer().setFocusedFrame((Frame)oWLProperty);
        this.repaint();
    }

    public void editingStopped(ChangeEvent changeEvent) {
        OWLClassesTab oWLClassesTab = this.getOWLClsesTab();
        super.editingStopped(changeEvent);
        if (this.tableModel.previouslyEditedCls != null) {
            this.setSelectedRow((RDFSClass)this.tableModel.previouslyEditedCls);
        }
        this.ensureEditedClassSelectedInExplorer(oWLClassesTab);
    }

    protected void editMultiLine() {
        OWLClassesTab oWLClassesTab = this.getOWLClsesTab();
        int n = this.getSelectedRow();
        super.editMultiLine();
        if (oWLClassesTab != null) {
            oWLClassesTab.ensureClassSelected(this.tableModel.getEditedCls(), n);
        }
    }

    public void ensureEditedClassSelectedInExplorer(OWLClassesTab oWLClassesTab) {
        if (oWLClassesTab != null) {
            OWLNamedClass oWLNamedClass = this.tableModel.getEditedCls();
            oWLClassesTab.ensureClassSelected(oWLNamedClass, this.getSelectedRow());
        }
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 == 0 && this.tableModel.isSeparator(n)) {
            return this.separatorCellRendererGrayed;
        }
        return super.getCellRenderer(n, n2);
    }

    public OWLClassesTab getOWLClsesTab() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof OWLClassesTab); container = container.getParent()) {
        }
        return (OWLClassesTab)((Object)container);
    }

    public List getPrototypeTriples() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 1 && this.tableModel.isSeparator(nArray[0])) {
            RDFProperty rDFProperty = null;
            rDFProperty = this.tableModel.isDefinition(nArray[0]) ? this.getOWLModel().getOWLEquivalentClassProperty() : this.getOWLModel().getRDFSSubClassOfProperty();
            return Collections.singletonList(new DefaultTriple(this.tableModel.getEditedCls(), rDFProperty, null));
        }
        return super.getPrototypeTriples();
    }

    public void hideSymbolPanel() {
        super.hideSymbolPanel();
        this.tableModel.removeEmptyRow();
        this.hidePropertyWindow();
    }

    protected boolean isTableHeaderHidden() {
        return true;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            int n;
            if (!this.tableModel.isSeparator(i) || !this.tableModel.isDefinition(i) || (n = this.tableModel.getBlockSize(i + 1)) <= 0) continue;
            this.paintEquivalentBlock(graphics, i + 1, n);
        }
    }

    private void paintEquivalentBlock(Graphics graphics, int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getRowHeight();
        int n5 = n3 - 35;
        int n6 = n4 * n + 1;
        int n7 = n4 * n2 - 2;
        graphics.setColor(new Color(255, 200, 128));
        graphics.fillRect(n5, n6, 31, n7);
        graphics.setColor(new Color(110, 110, 110));
        graphics.drawRect(n5, n6, 31, n7);
        int n8 = n6 + n7 / 2;
        graphics.setColor(Color.black);
        int n9 = n5 + 13;
        int n10 = n5 + 18;
        graphics.drawLine(n9, n8 - 2, n10, n8 - 2);
        graphics.drawLine(n9, n8, n10, n8);
        graphics.drawLine(n9, n8 + 2, n10, n8 + 2);
    }

    public void selectNecessaryIfNothingSelected() {
        int n = this.getSelectedRow();
        if (n < 0) {
            n = 1;
            while (this.tableModel.getType(n) != -1) {
                ++n;
            }
            this.setSelectedRow(n);
        }
    }

    public void setSelectedTriples(Collection collection) {
        Triple triple;
        this.tableModel.refresh();
        Iterator iterator = collection.iterator();
        if (iterator.hasNext() && (triple = (Triple)iterator.next()).getObject() instanceof RDFSClass) {
            RDFSClass rDFSClass = (RDFSClass)triple.getObject();
            this.setSelectedRow(rDFSClass);
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.previouslyEditedCls = null;
        if (object instanceof String) {
            try {
                String string = (String)object;
                this.getOWLModel().getOWLClassParser().checkClass(this.getOWLModel(), string);
                super.setValueAt(object, n, n2);
                if (this.tableModel.previouslyEditedCls != null) {
                    this.setSelectedRow((RDFSClass)this.tableModel.previouslyEditedCls);
                }
            }
            catch (Exception exception) {
                Log.emptyCatchBlock((Throwable)exception);
            }
        }
    }
}

