/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTable;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Component;
import java.util.Collection;

class AddNamedClassAction
extends ResourceSelectionAction
implements ConditionsTableConstants {
    private ConditionsTable table;

    AddNamedClassAction(ConditionsTable conditionsTable) {
        super("Add named class...", OWLIcons.getAddIcon("PrimitiveClass"));
        this.table = conditionsTable;
    }

    public void resourceSelected(RDFResource rDFResource) {
        OWLNamedClass oWLNamedClass = this.table.getEditedCls();
        this.table.selectNecessaryIfNothingSelected();
        OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab((Component)((Object)this.table));
        int n = this.table.addRow((Cls)rDFResource);
        if (oWLClassesTab != null) {
            oWLClassesTab.ensureClsSelected(oWLNamedClass, n);
        }
    }

    public Collection getSelectableResources() {
        Collection collection = this.table.getOWLModel().getUserDefinedOWLNamedClasses();
        collection.add(this.table.getOWLModel().getOWLThingClass());
        collection.remove(((OWLTableModel)this.table.getModel()).getEditedCls());
        ConditionsTableModel conditionsTableModel = (ConditionsTableModel)this.table.getModel();
        for (int i = 0; i < conditionsTableModel.getRowCount(); ++i) {
            RDFSClass rDFSClass = conditionsTableModel.getClass(i);
            if (!(rDFSClass instanceof OWLNamedClass)) continue;
            collection.remove(rDFSClass);
        }
        return collection;
    }

    public RDFResource pickResource() {
        return ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this.table), this.table.getOWLModel(), "Select a named class to add");
    }
}

