/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.components.triples.AbstractTriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.AddResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.CreateValueAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.DeleteTripleAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;

public class TriplesComponent
extends AbstractTriplesComponent {
    private Action deleteRowAction;
    private Action createObjectPropertyValueAction;
    private Action createDatatypePropertyValueAction;
    private Action addResourceAction;

    public TriplesComponent(RDFProperty rDFProperty) {
        this(rDFProperty, "Triples", OWLIcons.getImageIcon("Triples"));
    }

    public TriplesComponent(RDFProperty rDFProperty, boolean bl) {
        this(rDFProperty, "Triples", OWLIcons.getImageIcon("Triples"), bl);
    }

    public TriplesComponent(RDFProperty rDFProperty, String string, Icon icon) {
        this(rDFProperty, string, icon, false);
    }

    public TriplesComponent(RDFProperty rDFProperty, String string, Icon icon, boolean bl) {
        super(rDFProperty, string, icon, bl);
    }

    protected void addButtons(LabeledComponent labeledComponent) {
        this.createDatatypePropertyValueAction = new CreateValueAction(this.getTable(), "Create datatype property value...", OWLIcons.getCreateIndividualIcon("DatatypeTriple")){

            protected Collection getAllowedProperties(OWLModel oWLModel) {
                ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
                Iterator iterator = oWLModel.getRDFProperties().iterator();
                RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.table.getTableModel().getSubject().getRDFType();
                while (iterator.hasNext()) {
                    RDFProperty rDFProperty = (RDFProperty)iterator.next();
                    if (!rDFProperty.isVisible() || !rDFProperty.hasDatatypeRange() && !TriplesComponent.this.isDatatypeProperty(rDFProperty, rDFSNamedClass)) continue;
                    arrayList.add(rDFProperty);
                }
                arrayList.remove(oWLModel.getSystemFrames().getPalDescriptionSlot());
                arrayList.remove(oWLModel.getSystemFrames().getPalNameSlot());
                arrayList.remove(oWLModel.getSystemFrames().getPalRangeSlot());
                arrayList.remove(oWLModel.getSystemFrames().getPalStatementSlot());
                return arrayList;
            }
        };
        labeledComponent.addHeaderButton(this.createDatatypePropertyValueAction);
        this.createObjectPropertyValueAction = new CreateValueAction(this.getTable(), "Create object property value...", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

            protected Collection getAllowedProperties(OWLModel oWLModel) {
                ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
                Iterator iterator = super.getAllowedProperties(oWLModel).iterator();
                RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.table.getTableModel().getSubject().getRDFType();
                while (iterator.hasNext()) {
                    RDFProperty rDFProperty = (RDFProperty)iterator.next();
                    if (TriplesComponent.this.isDatatypeProperty(rDFProperty, rDFSNamedClass) || !rDFProperty.isAnnotationProperty() && rDFProperty.isSystem()) continue;
                    arrayList.add(rDFProperty);
                }
                return arrayList;
            }
        };
        labeledComponent.addHeaderButton(this.createObjectPropertyValueAction);
        this.addResourceAction = new AddResourceAction(this.getTable());
        labeledComponent.addHeaderButton(this.addResourceAction);
        this.deleteRowAction = new DeleteTripleAction(this.getTable());
        labeledComponent.addHeaderButton(this.deleteRowAction);
    }

    private boolean isDatatypeProperty(RDFProperty rDFProperty, RDFSNamedClass rDFSNamedClass) {
        if (!rDFProperty.hasObjectRange()) {
            if (rDFSNamedClass instanceof OWLNamedClass) {
                RDFResource rDFResource = ((OWLNamedClass)rDFSNamedClass).getAllValuesFrom(rDFProperty);
                if (rDFResource instanceof RDFSDatatype) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected void updateActions() {
        super.updateActions();
        int n = this.getTable().getSelectedRow();
        TriplesTableModel triplesTableModel = this.getTable().getTableModel();
        boolean bl = false;
        if (n >= 0) {
            bl = triplesTableModel.isDeleteEnabled(n);
        }
        this.deleteRowAction.setEnabled(this.isEnabled() && bl);
    }

    public void setEnabled(boolean bl) {
        this.createDatatypePropertyValueAction.setEnabled(bl);
        this.createObjectPropertyValueAction.setEnabled(bl);
        this.addResourceAction.setEnabled(bl);
        this.deleteRowAction.setEnabled(bl);
        this.getTable().setEnabled(bl);
        super.setEnabled(bl);
    }
}

