/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditorManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metadata.AnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.metadata.DateAnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.metadata.DateTimeAnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.metadata.TimeAnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTriplesComponent
extends AbstractPropertyValuesComponent
implements Disposable {
    private Icon icon;
    private OWLModel owlModel;
    private static Set<AnnotationsWidgetPlugin> plugins = new HashSet<AnnotationsWidgetPlugin>();
    private TriplesTable table;
    private TriplesTableModel tableModel;
    private Action viewValueAction;
    private boolean enabled = true;

    public AbstractTriplesComponent(RDFProperty rDFProperty) {
        this(rDFProperty, "Triples", OWLIcons.getImageIcon("Triple"));
    }

    public AbstractTriplesComponent(RDFProperty rDFProperty, String string, Icon icon) {
        this(rDFProperty, string, icon, false);
    }

    public AbstractTriplesComponent(RDFProperty rDFProperty, String string, Icon icon, boolean bl) {
        super(rDFProperty, string, bl);
        this.icon = icon;
        AbstractTriplesComponent.addPlugin(new DateAnnotationsWidgetPlugin());
        AbstractTriplesComponent.addPlugin(new DateTimeAnnotationsWidgetPlugin());
        AbstractTriplesComponent.addPlugin(new TimeAnnotationsWidgetPlugin());
        this.owlModel = this.getOWLModel();
        this.viewValueAction = new AbstractAction("View selected value", OWLIcons.getViewIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTriplesComponent.this.viewValue();
            }
        };
        this.viewValueAction.setEnabled(false);
        this.tableModel = this.createTableModel();
        this.table = this.createTable(this.owlModel.getProject());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AbstractTriplesComponent.this.handleSelectionChanged();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && AbstractTriplesComponent.this.isEnabled()) {
                    AbstractTriplesComponent.this.handleTableDoubleClick();
                }
            }
        });
        this.addContainerListener(new ContainerAdapter(){

            public void componentRemoved(ContainerEvent containerEvent) {
                AbstractTriplesComponent.this.stopCellEditing();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent(string, jScrollPane, true, true);
        if (icon != null) {
            oWLLabeledComponent.setHeaderIcon(icon);
        }
        WidgetUtilities.addViewButton(oWLLabeledComponent, this.viewValueAction);
        this.addButtons(oWLLabeledComponent);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    protected abstract void addButtons(LabeledComponent var1);

    public static void addPlugin(AnnotationsWidgetPlugin annotationsWidgetPlugin) {
        for (AnnotationsWidgetPlugin annotationsWidgetPlugin2 : plugins) {
            if (annotationsWidgetPlugin2.getClass() != annotationsWidgetPlugin.getClass()) continue;
            return;
        }
        plugins.add(annotationsWidgetPlugin);
    }

    protected TriplesTable createTable(Project project) {
        return new TriplesTable(project, this.tableModel, "property");
    }

    protected TriplesTableModel createTableModel() {
        return new TriplesTableModel(null);
    }

    @Override
    public void dispose() {
        this.tableModel.dispose();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public TriplesTable getTable() {
        return this.table;
    }

    public TriplesTableModel getTableModel() {
        return this.tableModel;
    }

    protected void handleSelectionChanged() {
        this.updateActions();
    }

    private void handleTableDoubleClick() {
        int n = this.table.getSelectedRow();
        RDFProperty rDFProperty = this.tableModel.getPredicate(n);
        if (n >= 0 && n < this.tableModel.getRowCount() && !rDFProperty.isReadOnly() && this.viewValueAction.isEnabled()) {
            this.viewValue();
        }
    }

    public static Iterator<AnnotationsWidgetPlugin> plugins() {
        return plugins.iterator();
    }

    public static void removePlugin(AnnotationsWidgetPlugin annotationsWidgetPlugin) {
        plugins.remove(annotationsWidgetPlugin);
    }

    @Override
    public void setSubject(RDFResource rDFResource) {
        super.setSubject(rDFResource);
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.tableModel.setSubject(rDFResource);
    }

    protected void updateActions() {
        RDFProperty rDFProperty;
        int n = this.table.getSelectedRow();
        RDFProperty rDFProperty2 = rDFProperty = n >= 0 ? this.tableModel.getPredicate(n) : null;
        if (n >= 0) {
            Object object = this.tableModel.getValue(n);
            this.viewValueAction.setEnabled(true);
        } else {
            this.viewValueAction.setEnabled(false);
        }
    }

    @Override
    public void valuesChanged() {
        this.tableModel.updateValues();
    }

    private void viewValue() {
        int n = this.table.getSelectedRow();
        this.viewValue(n);
    }

    private void viewValue(int n) {
        Object object = this.tableModel.getValue(n);
        if (object instanceof RDFResource) {
            ProtegeUI.show((RDFResource)object);
        } else {
            RDFProperty rDFProperty = this.tableModel.getPredicate(n);
            RDFResource rDFResource = this.tableModel.getSubject();
            PropertyValueEditor propertyValueEditor = PropertyValueEditorManager.getEditor(rDFResource, rDFProperty, object);
            if (propertyValueEditor != null && !rDFProperty.isReadOnly()) {
                Object object3 = propertyValueEditor.editValue(this, rDFResource, rDFProperty, object);
                if (object3 != null) {
                    this.tableModel.setValue(object3, n);
                    return;
                }
                return;
            }
            for (AnnotationsWidgetPlugin object22 : plugins) {
                if (!object22.canEdit(rDFResource, rDFProperty, object)) continue;
                Object jScrollPane = object22.editValue(null, rDFResource, rDFProperty, object);
                if (jScrollPane != null) {
                    this.tableModel.setValue(jScrollPane, n);
                }
                return;
            }
            Object object5 = rDFProperty.getBrowserText();
            object5 = Character.toUpperCase(((String)object5).charAt(0)) + ((String)object5).substring(1);
            JTextArea jTextArea = new JTextArea(object.toString());
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(!rDFProperty.isReadOnly());
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            LabeledComponent labeledComponent = new LabeledComponent((String)object5, (Component)jScrollPane);
            labeledComponent.setPreferredSize(new Dimension(400, 400));
            int n2 = ProtegeUI.getModalDialogFactory().showDialog(this, (Component)labeledComponent, "Edit annotation", 11);
            if (n2 == 1 && !rDFProperty.isReadOnly()) {
                String string = jTextArea.getText();
                this.tableModel.setValue(string, n);
            }
        }
    }

    private boolean stopCellEditing() {
        try {
            int n = this.table.getEditingColumn();
            if (n > -1) {
                TableCellEditor tableCellEditor = this.table.getColumnModel().getColumn(n).getCellEditor();
                if (tableCellEditor == null) {
                    tableCellEditor = this.table.getDefaultEditor(this.table.getColumnClass(n));
                }
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

