/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.singleresource;

import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.PropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.dialogs.DefaultSelectionDialogFactory;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SetResourceAction
extends ResourceSelectionAction {
    private PropertyValuesComponent component;

    public SetResourceAction(PropertyValuesComponent propertyValuesComponent) {
        super("Select existing resource...", OWLIcons.getAddIcon("RDFIndividual"));
        this.component = propertyValuesComponent;
    }

    public Collection getEnumeratedValues(Collection collection) {
        HashSet hashSet = new HashSet();
        for (RDFSClass rDFSClass : collection) {
            if (!(rDFSClass instanceof OWLEnumeratedClass)) continue;
            hashSet.addAll(((OWLEnumeratedClass)rDFSClass).getOneOf());
        }
        return hashSet;
    }

    public Collection getSelectableResources() {
        RDFProperty rDFProperty;
        RDFResource rDFResource = this.component.getSubject();
        Set set = this.getUnionRangeClasses(rDFResource, rDFProperty = this.component.getPredicate(), true);
        Collection collection = this.getEnumeratedValues(set);
        if (collection.size() > 0) {
            return collection;
        }
        if (set.contains(rDFResource.getOWLModel().getOWLThingClass())) {
            return rDFResource.getOWLModel().getUserDefinedRDFIndividuals(true);
        }
        HashSet hashSet = new HashSet();
        for (RDFSClass rDFSClass : set) {
            hashSet.addAll(rDFSClass.getInstances(true));
        }
        return hashSet;
    }

    private Set getUnionRangeClasses(RDFResource rDFResource, RDFProperty rDFProperty, boolean bl) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        HashSet<RDFSClass> hashSet = new HashSet<RDFSClass>();
        for (RDFSClass rDFSClass : rDFResource.getRDFTypes()) {
            if (!(rDFSClass instanceof RDFSNamedClass)) continue;
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)rDFSClass;
            Collection collection = rDFSNamedClass.getUnionRangeClasses(rDFProperty);
            for (RDFSClass rDFSClass2 : collection) {
                if (!(rDFSClass2 instanceof RDFSNamedClass) && (!bl || !(rDFSClass2 instanceof OWLEnumeratedClass))) continue;
                hashSet.add(rDFSClass2);
            }
        }
        if (hashSet.isEmpty()) {
            hashSet.add(oWLModel.getOWLThingClass());
        }
        return hashSet;
    }

    public RDFResource pickResource() {
        RDFResource rDFResource = this.component.getSubject();
        RDFProperty rDFProperty = this.component.getPredicate();
        OWLModel oWLModel = rDFProperty.getOWLModel();
        Set set = this.getUnionRangeClasses(rDFResource, rDFProperty, true);
        Collection collection = this.getEnumeratedValues(set);
        if (collection.isEmpty()) {
            Set set2 = this.getUnionRangeClasses(rDFResource, rDFProperty, false);
            if (OWLUI.isExternalResourcesSupported(oWLModel)) {
                oWLModel.getRDFUntypedResourcesClass().setVisible(true);
                set2.add(oWLModel.getRDFUntypedResourcesClass());
            }
            RDFResource rDFResource2 = new DefaultSelectionDialogFactory().selectResourceWithBrowserTextByType((Component)((Object)this.component), oWLModel, set2, "Select Resource");
            oWLModel.getRDFUntypedResourcesClass().setVisible(false);
            return rDFResource2;
        }
        return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection((Component)((Object)this.component), oWLModel, collection, (String)this.getValue("Name"));
    }

    public void resourceSelected(RDFResource rDFResource) {
        this.component.getSubject().setPropertyValue(this.component.getPredicate(), rDFResource);
    }
}

